"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtOneDrilldown = exports.txtManyDrilldowns = exports.PanelNotificationsAction = exports.ACTION_PANEL_NOTIFICATIONS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _has_dynamic_actions = require("../embeddables/interfaces/has_dynamic_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const txtOneDrilldown = exports.txtOneDrilldown = _i18n.i18n.translate('xpack.embeddableEnhanced.actions.panelNotifications.oneDrilldown', {
  defaultMessage: 'Panel has 1 drilldown'
});
const txtManyDrilldowns = count => _i18n.i18n.translate('xpack.embeddableEnhanced.actions.panelNotifications.manyDrilldowns', {
  defaultMessage: 'Panel has {count} drilldowns',
  values: {
    count: String(count)
  }
});
exports.txtManyDrilldowns = txtManyDrilldowns;
const ACTION_PANEL_NOTIFICATIONS = exports.ACTION_PANEL_NOTIFICATIONS = 'ACTION_PANEL_NOTIFICATIONS';
const isApiCompatible = api => (0, _has_dynamic_actions.apiHasDynamicActions)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api);

/**
 * This action renders in "edit" mode number of events (dynamic action) a panel
 * has attached to it.
 */
class PanelNotificationsAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ACTION_PANEL_NOTIFICATIONS);
    (0, _defineProperty2.default)(this, "type", ACTION_PANEL_NOTIFICATIONS);
    (0, _defineProperty2.default)(this, "getIconType", () => '');
    (0, _defineProperty2.default)(this, "getDisplayName", ({
      embeddable
    }) => {
      return String(this.getEventCount({
        embeddable
      }));
    });
    (0, _defineProperty2.default)(this, "subscribeToCompatibilityChanges", ({
      embeddable
    }, onChange) => {
      var _getViewModeSubject;
      if (!isApiCompatible(embeddable)) return;
      const viewModeSubject = (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(embeddable)) !== null && _getViewModeSubject !== void 0 ? _getViewModeSubject : new _rxjs.BehaviorSubject(_public.ViewMode.VIEW);
      return (0, _rxjs.merge)(embeddable.dynamicActionsState$, viewModeSubject).subscribe(() => {
        onChange((0, _presentationPublishing.getInheritedViewMode)(embeddable) === _public.ViewMode.EDIT && this.getEventCount({
          embeddable
        }) > 0, this);
      });
    });
    (0, _defineProperty2.default)(this, "getDisplayNameTooltip", ({
      embeddable
    }) => {
      const count = this.getEventCount({
        embeddable
      });
      return !count ? '' : count === 1 ? txtOneDrilldown : txtManyDrilldowns(count);
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      return isApiCompatible(embeddable) && (0, _presentationPublishing.getInheritedViewMode)(embeddable) === _public.ViewMode.EDIT && this.getEventCount({
        embeddable
      }) > 0;
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
  }
  getEventCount({
    embeddable
  }) {
    var _embeddable$dynamicAc, _embeddable$dynamicAc2;
    return isApiCompatible(embeddable) ? ((_embeddable$dynamicAc = (_embeddable$dynamicAc2 = embeddable.dynamicActionsState$.getValue()) === null || _embeddable$dynamicAc2 === void 0 ? void 0 : _embeddable$dynamicAc2.dynamicActions.events) !== null && _embeddable$dynamicAc !== void 0 ? _embeddable$dynamicAc : []).length : 0;
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
}
exports.PanelNotificationsAction = PanelNotificationsAction;