"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _fp = require("lodash/fp");
var _post_attack_discovery = require("./attack_discovery/post_attack_discovery");
var _create_route = require("./user_conversations/create_route");
var _delete_route = require("./user_conversations/delete_route");
var _read_route = require("./user_conversations/read_route");
var _update_route = require("./user_conversations/update_route");
var _find_route = require("./user_conversations/find_route");
var _bulk_actions_route = require("./user_conversations/bulk_actions_route");
var _append_conversation_messages_route = require("./user_conversations/append_conversation_messages_route");
var _delete_knowledge_base = require("./knowledge_base/delete_knowledge_base");
var _get_knowledge_base_status = require("./knowledge_base/get_knowledge_base_status");
var _post_knowledge_base = require("./knowledge_base/post_knowledge_base");
var _get_evaluate = require("./evaluate/get_evaluate");
var _post_evaluate = require("./evaluate/post_evaluate");
var _post_actions_connector_execute = require("./post_actions_connector_execute");
var _get_capabilities_route = require("./capabilities/get_capabilities_route");
var _bulk_actions_route2 = require("./prompts/bulk_actions_route");
var _find_route2 = require("./prompts/find_route");
var _bulk_actions_route3 = require("./anonymization_fields/bulk_actions_route");
var _find_route3 = require("./anonymization_fields/find_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, logger, plugins) => {
  // Capabilities
  (0, _get_capabilities_route.getCapabilitiesRoute)(router);

  // User Conversations CRUD
  (0, _create_route.createConversationRoute)(router);
  (0, _read_route.readConversationRoute)(router);
  (0, _update_route.updateConversationRoute)(router);
  (0, _delete_route.deleteConversationRoute)(router);
  (0, _append_conversation_messages_route.appendConversationMessageRoute)(router);

  // User Conversations bulk CRUD
  (0, _bulk_actions_route.bulkActionConversationsRoute)(router, logger);

  // User Conversations search
  (0, _find_route.findUserConversationsRoute)(router);

  // Knowledge Base
  (0, _delete_knowledge_base.deleteKnowledgeBaseRoute)(router);
  const getElserId = (0, _fp.once)(async (request, savedObjectsClient) => {
    return (await plugins.ml.trainedModelsProvider(request, savedObjectsClient).getELSER()).model_id;
  });
  (0, _get_knowledge_base_status.getKnowledgeBaseStatusRoute)(router, getElserId);
  (0, _post_knowledge_base.postKnowledgeBaseRoute)(router, getElserId);

  // Actions Connector Execute (LLM Wrapper)
  (0, _post_actions_connector_execute.postActionsConnectorExecuteRoute)(router, getElserId);

  // Evaluate
  (0, _get_evaluate.getEvaluateRoute)(router);
  (0, _post_evaluate.postEvaluateRoute)(router, getElserId);

  // Prompts
  (0, _bulk_actions_route2.bulkPromptsRoute)(router, logger);
  (0, _find_route2.findPromptsRoute)(router, logger);

  // Anonymization Fields
  (0, _bulk_actions_route3.bulkActionAnonymizationFieldsRoute)(router, logger);
  (0, _find_route3.findAnonymizationFieldsRoute)(router, logger);

  // Attack Discovery
  (0, _post_attack_discovery.postAttackDiscoveryRoute)(router);
};
exports.registerRoutes = registerRoutes;