"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_EXECUTOR_MAP = void 0;
var _execute_custom_llm_chain = require("../execute_custom_llm_chain");
var _openai_functions_executor = require("./openai_functions_executor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * To support additional Agent Executors from the UI, add them to this map
 * and reference your specific AgentExecutor function
 */
const AGENT_EXECUTOR_MAP = exports.AGENT_EXECUTOR_MAP = {
  DefaultAgentExecutor: _execute_custom_llm_chain.callAgentExecutor,
  OpenAIFunctionsExecutor: _openai_functions_executor.callOpenAIFunctionsExecutor
};