"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryFilter = exports.findDocuments = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findDocuments = async ({
  esClient,
  filter,
  page,
  perPage,
  sortField,
  index,
  fields,
  sortOrder,
  logger
}) => {
  const query = getQueryFilter({
    filter
  });
  let sort;
  const ascOrDesc = sortOrder !== null && sortOrder !== void 0 ? sortOrder : 'asc';
  if (sortField != null) {
    sort = [{
      [sortField]: ascOrDesc
    }];
  } else {
    sort = {
      updated_at: {
        order: 'desc'
      }
    };
  }
  try {
    var _ref, _response$hits$total;
    const response = await esClient.search({
      body: {
        query,
        track_total_hits: true,
        sort
      },
      _source: true,
      from: (page - 1) * perPage,
      ignore_unavailable: true,
      index,
      seq_no_primary_term: true,
      size: perPage
    });
    return {
      data: response,
      page,
      perPage,
      total: (_ref = typeof response.hits.total === 'number' ? response.hits.total // This format is to be removed in 8.0
      : (_response$hits$total = response.hits.total) === null || _response$hits$total === void 0 ? void 0 : _response$hits$total.value) !== null && _ref !== void 0 ? _ref : 0
    };
  } catch (err) {
    logger.error(`Error fetching documents: ${err}`);
    throw err;
  }
};
exports.findDocuments = findDocuments;
const getQueryFilter = ({
  filter
}) => {
  const kqlQuery = filter ? {
    language: 'kuery',
    query: filter
  } : [];
  const config = {
    allowLeadingWildcards: true,
    dateFormatTZ: 'Zulu',
    ignoreFilterIfFieldNotInIndex: false,
    queryStringOptions: {
      analyze_wildcard: true
    }
  };
  return (0, _esQuery.buildEsQuery)(undefined, kqlQuery, [], config);
};
exports.getQueryFilter = getQueryFilter;