"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformBulkActionResponse = exports.PerformBulkActionRequestBody = exports.NormalizedConversationError = exports.ConversationDetailsInError = exports.BulkCrudActionSummary = exports.BulkCrudActionResults = exports.BulkCrudActionResponse = exports.BulkActionSkipResult = exports.BulkActionSkipReason = exports.BulkActionBase = void 0;
var _zod = require("zod");
var _common_attributes = require("./common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Actions API endpoint
 *   version: 1
 */

const BulkActionSkipReason = exports.BulkActionSkipReason = _zod.z.literal('CONVERSATION_NOT_MODIFIED');
const BulkActionSkipResult = exports.BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: BulkActionSkipReason
});
const ConversationDetailsInError = exports.ConversationDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const NormalizedConversationError = exports.NormalizedConversationError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  conversations: _zod.z.array(ConversationDetailsInError)
});
const BulkCrudActionResults = exports.BulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(_common_attributes.ConversationResponse),
  created: _zod.z.array(_common_attributes.ConversationResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(BulkActionSkipResult)
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const BulkCrudActionResponse = exports.BulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  conversations_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkCrudActionResults,
    summary: BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedConversationError).optional()
  })
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter conversations
   */
  query: _zod.z.string().optional(),
  /**
   * Array of conversation IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.object({
  delete: BulkActionBase.optional(),
  create: _zod.z.array(_common_attributes.ConversationCreateProps).optional(),
  update: _zod.z.array(_common_attributes.ConversationUpdateProps).optional()
});
const PerformBulkActionResponse = exports.PerformBulkActionResponse = BulkCrudActionResponse;