"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortOrderEnum = exports.SortOrder = exports.FindAnonymizationFieldsSortFieldEnum = exports.FindAnonymizationFieldsSortField = exports.FindAnonymizationFieldsResponse = exports.FindAnonymizationFieldsRequestQuery = void 0;
var _zod = require("zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _bulk_crud_anonymization_fields_route = require("./bulk_crud_anonymization_fields_route.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find AnonymizationFields API endpoint
 *   version: 1
 */

const FindAnonymizationFieldsSortField = exports.FindAnonymizationFieldsSortField = _zod.z.enum(['created_at', 'anonymized', 'allowed', 'field', 'updated_at']);
const FindAnonymizationFieldsSortFieldEnum = exports.FindAnonymizationFieldsSortFieldEnum = FindAnonymizationFieldsSortField.enum;
const SortOrder = exports.SortOrder = _zod.z.enum(['asc', 'desc']);
const SortOrderEnum = exports.SortOrderEnum = SortOrder.enum;
const FindAnonymizationFieldsRequestQuery = exports.FindAnonymizationFieldsRequestQuery = _zod.z.object({
  fields: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  /**
   * Search query
   */
  filter: _zod.z.string().optional(),
  /**
   * Field to sort by
   */
  sort_field: FindAnonymizationFieldsSortField.optional(),
  /**
   * Sort order
   */
  sort_order: SortOrder.optional(),
  /**
   * Page number
   */
  page: _zod.z.coerce.number().int().min(1).optional().default(1),
  /**
   * AnonymizationFields per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional().default(20)
});
const FindAnonymizationFieldsResponse = exports.FindAnonymizationFieldsResponse = _zod.z.object({
  page: _zod.z.number().int(),
  perPage: _zod.z.number().int(),
  total: _zod.z.number().int(),
  data: _zod.z.array(_bulk_crud_anonymization_fields_route.AnonymizationFieldResponse)
});