"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformBulkActionResponse = exports.PerformBulkActionRequestBody = exports.NormalizedAnonymizationFieldError = exports.BulkCrudActionSummary = exports.BulkCrudActionResults = exports.BulkCrudActionResponse = exports.BulkActionSkipResult = exports.BulkActionSkipReason = exports.BulkActionBase = exports.AnonymizationFieldUpdateProps = exports.AnonymizationFieldResponse = exports.AnonymizationFieldDetailsInError = exports.AnonymizationFieldCreateProps = void 0;
var _zod = require("zod");
var _common_attributes = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk Actions API endpoint
 *   version: 1
 */

const BulkActionSkipReason = exports.BulkActionSkipReason = _zod.z.literal('ANONYMIZATION_FIELD_NOT_MODIFIED');
const BulkActionSkipResult = exports.BulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  skip_reason: BulkActionSkipReason
});
const AnonymizationFieldDetailsInError = exports.AnonymizationFieldDetailsInError = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional()
});
const NormalizedAnonymizationFieldError = exports.NormalizedAnonymizationFieldError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  anonymization_fields: _zod.z.array(AnonymizationFieldDetailsInError)
});
const AnonymizationFieldResponse = exports.AnonymizationFieldResponse = _zod.z.object({
  id: _common_attributes.UUID,
  timestamp: _common_attributes.NonEmptyString.optional(),
  field: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional(),
  updatedAt: _zod.z.string().optional(),
  updatedBy: _zod.z.string().optional(),
  createdAt: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string().optional()
});
const BulkCrudActionResults = exports.BulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(AnonymizationFieldResponse),
  created: _zod.z.array(AnonymizationFieldResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(BulkActionSkipResult)
});
const BulkCrudActionSummary = exports.BulkCrudActionSummary = _zod.z.object({
  failed: _zod.z.number().int(),
  skipped: _zod.z.number().int(),
  succeeded: _zod.z.number().int(),
  total: _zod.z.number().int()
});
const BulkCrudActionResponse = exports.BulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  anonymization_fields_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: BulkCrudActionResults,
    summary: BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedAnonymizationFieldError).optional()
  })
});
const BulkActionBase = exports.BulkActionBase = _zod.z.object({
  /**
   * Query to filter anonymization fields
   */
  query: _zod.z.string().optional(),
  /**
   * Array of anonymization fields IDs
   */
  ids: _zod.z.array(_zod.z.string()).min(1).optional()
});
const AnonymizationFieldCreateProps = exports.AnonymizationFieldCreateProps = _zod.z.object({
  field: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional()
});
const AnonymizationFieldUpdateProps = exports.AnonymizationFieldUpdateProps = _zod.z.object({
  id: _zod.z.string(),
  allowed: _zod.z.boolean().optional(),
  anonymized: _zod.z.boolean().optional()
});
const PerformBulkActionRequestBody = exports.PerformBulkActionRequestBody = _zod.z.object({
  delete: BulkActionBase.optional(),
  create: _zod.z.array(AnonymizationFieldCreateProps).optional(),
  update: _zod.z.array(AnonymizationFieldUpdateProps).optional()
});
const PerformBulkActionResponse = exports.PerformBulkActionResponse = BulkCrudActionResponse;