"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientLlm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _llms = require("@langchain/core/language_models/llms");
var _fp = require("lodash/fp");
var _uuid = require("uuid");
var _constants = require("./constants");
var _helpers = require("./helpers");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LLM_TYPE = 'ActionsClientLlm';
var _actions = /*#__PURE__*/new WeakMap();
var _connectorId = /*#__PURE__*/new WeakMap();
var _logger = /*#__PURE__*/new WeakMap();
var _request = /*#__PURE__*/new WeakMap();
var _traceId = /*#__PURE__*/new WeakMap();
var _timeout = /*#__PURE__*/new WeakMap();
class ActionsClientLlm extends _llms.LLM {
  constructor({
    actions,
    connectorId,
    traceId = (0, _uuid.v4)(),
    llmType,
    logger,
    model,
    request,
    temperature,
    timeout,
    traceOptions
  }) {
    var _traceOptions$tracers;
    super({
      callbacks: [...((_traceOptions$tracers = traceOptions === null || traceOptions === void 0 ? void 0 : traceOptions.tracers) !== null && _traceOptions$tracers !== void 0 ? _traceOptions$tracers : [])]
    });
    _classPrivateFieldInitSpec(this, _actions, void 0);
    _classPrivateFieldInitSpec(this, _connectorId, void 0);
    _classPrivateFieldInitSpec(this, _logger, void 0);
    _classPrivateFieldInitSpec(this, _request, void 0);
    _classPrivateFieldInitSpec(this, _traceId, void 0);
    _classPrivateFieldInitSpec(this, _timeout, void 0);
    // Local `llmType` as it can change and needs to be accessed by abstract `_llmType()` method
    // Not using getter as `this._llmType()` is called in the constructor via `super({})`
    (0, _defineProperty2.default)(this, "llmType", void 0);
    (0, _defineProperty2.default)(this, "model", void 0);
    (0, _defineProperty2.default)(this, "temperature", void 0);
    _classPrivateFieldSet(_actions, this, actions);
    _classPrivateFieldSet(_connectorId, this, connectorId);
    _classPrivateFieldSet(_traceId, this, traceId);
    this.llmType = llmType !== null && llmType !== void 0 ? llmType : LLM_TYPE;
    _classPrivateFieldSet(_logger, this, logger);
    _classPrivateFieldSet(_request, this, request);
    _classPrivateFieldSet(_timeout, this, timeout);
    this.model = model;
    this.temperature = temperature;
  }
  _llmType() {
    return this.llmType;
  }

  // Model type needs to be `base_chat_model` to work with LangChain OpenAI Tools
  // We may want to make this configurable (ala _llmType) if different agents end up requiring different model types
  // See: https://github.com/langchain-ai/langchainjs/blob/fb699647a310c620140842776f4a7432c53e02fa/langchain/src/agents/openai/index.ts#L185
  _modelType() {
    return 'base_chat_model';
  }
  async _call(prompt) {
    var _classPrivateFieldGet2;
    // convert the Langchain prompt to an assistant message:
    const assistantMessage = (0, _helpers.getMessageContentAndRole)(prompt);
    _classPrivateFieldGet(_logger, this).debug(`ActionsClientLlm#_call\ntraceId: ${_classPrivateFieldGet(_traceId, this)}\nassistantMessage:\n${JSON.stringify(assistantMessage)} `);
    // create a new connector request body with the assistant message:
    const requestBody = {
      actionId: _classPrivateFieldGet(_connectorId, this),
      params: {
        // hard code to non-streaming subaction as this class only supports non-streaming
        subAction: 'invokeAI',
        subActionParams: {
          model: this.model,
          messages: [assistantMessage],
          // the assistant message
          ...(0, _constants.getDefaultArguments)(this.llmType, this.temperature),
          // This timeout is large because LangChain prompts can be complicated and take a long time
          timeout: (_classPrivateFieldGet2 = _classPrivateFieldGet(_timeout, this)) !== null && _classPrivateFieldGet2 !== void 0 ? _classPrivateFieldGet2 : _constants.DEFAULT_TIMEOUT
        }
      }
    };

    // create an actions client from the authenticated request context:
    const actionsClient = await _classPrivateFieldGet(_actions, this).getActionsClientWithRequest(_classPrivateFieldGet(_request, this));
    const actionResult = await actionsClient.execute(requestBody);
    if (actionResult.status === 'error') {
      throw new Error(`${LLM_TYPE}: action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
    }
    const content = (0, _fp.get)('data.message', actionResult);
    if (typeof content !== 'string') {
      throw new Error(`${LLM_TYPE}: content should be a string, but it had an unexpected type: ${typeof content}`);
    }
    return content; // per the contact of _call, return a string
  }
}
exports.ActionsClientLlm = ActionsClientLlm;