"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultDocument = exports.PostResultBody = exports.GetResultQuery = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultDocumentInterface = t.interface({
  batchId: t.string,
  indexName: t.string,
  isCheckAll: t.boolean,
  checkedAt: t.number,
  docsCount: t.number,
  totalFieldCount: t.number,
  ecsFieldCount: t.number,
  customFieldCount: t.number,
  incompatibleFieldCount: t.number,
  sameFamilyFieldCount: t.number,
  sameFamilyFields: t.array(t.string),
  unallowedMappingFields: t.array(t.string),
  unallowedValueFields: t.array(t.string),
  sizeInBytes: t.number,
  ilmPhase: t.string,
  markdownComments: t.array(t.string),
  ecsVersion: t.string,
  indexId: t.string,
  error: t.union([t.string, t.null])
});
const ResultDocumentOptional = t.partial({
  indexPattern: t.string,
  checkedBy: t.string
});
const ResultDocument = exports.ResultDocument = t.intersection([ResultDocumentInterface, ResultDocumentOptional]);
const PostResultBody = exports.PostResultBody = ResultDocument;
const GetResultQuery = exports.GetResultQuery = t.type({
  pattern: t.string
});