"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsDataQualityDashboardPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _constants = require("@kbn/spaces-plugin/common/constants");
var _routes = require("./routes");
var _results_data_stream = require("./lib/data_stream/results_data_stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EcsDataQualityDashboardPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "resultsDataStream", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    this.logger = initializerContext.logger.get();
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.resultsDataStream = new _results_data_stream.ResultsDataStream({
      kibanaVersion: initializerContext.env.packageInfo.version
    });
  }
  setup(core, plugins) {
    this.logger.debug('ecsDataQualityDashboard: Setup');
    this.resultsDataStream.install({
      esClient: core.getStartServices().then(([{
        elasticsearch
      }]) => elasticsearch.client.asInternalUser),
      logger: this.logger,
      pluginStop$: this.pluginStop$
    });
    core.http.registerRouteHandlerContext('dataQualityDashboard', (_context, request) => {
      var _plugins$spaces$space, _plugins$spaces;
      const spaceId = (_plugins$spaces$space = (_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.spacesService.getSpaceId(request)) !== null && _plugins$spaces$space !== void 0 ? _plugins$spaces$space : _constants.DEFAULT_SPACE_ID;
      return {
        spaceId,
        getResultsIndexName: async () => this.resultsDataStream.installSpace(spaceId)
      };
    });
    const router = core.http.createRouter();

    // Register server side APIs
    (0, _routes.getIndexMappingsRoute)(router, this.logger);
    (0, _routes.getIndexStatsRoute)(router, this.logger);
    (0, _routes.getUnallowedFieldValuesRoute)(router, this.logger);
    (0, _routes.getILMExplainRoute)(router, this.logger);
    (0, _routes.resultsRoutes)(router, this.logger);
    return {};
  }
  start(core) {
    this.logger.debug('ecsDataQualityDashboard: Started');
    return {};
  }
  stop() {
    this.pluginStop$.next();
    this.pluginStop$.complete();
  }
}
exports.EcsDataQualityDashboardPlugin = EcsDataQualityDashboardPlugin;