"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewSavedSearchAction = exports.ACTION_VIEW_SAVED_SEARCH = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _discoverUtils = require("@kbn/discover-utils");
var _public = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _get_discover_locator_params = require("./get_discover_locator_params");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_VIEW_SAVED_SEARCH = exports.ACTION_VIEW_SAVED_SEARCH = 'ACTION_VIEW_SAVED_SEARCH';
const compatibilityCheck = api => {
  return (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.getInheritedViewMode)(api) === _public.ViewMode.VIEW && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiIsOfType)(api, _discoverUtils.SEARCH_EMBEDDABLE_TYPE) && (0, _types.apiHasSavedSearch)(api);
};
class ViewSavedSearchAction {
  constructor(application, locator) {
    (0, _defineProperty2.default)(this, "id", ACTION_VIEW_SAVED_SEARCH);
    (0, _defineProperty2.default)(this, "type", ACTION_VIEW_SAVED_SEARCH);
    this.application = application;
    this.locator = locator;
  }
  async execute({
    embeddable
  }) {
    if (!compatibilityCheck(embeddable)) {
      return;
    }
    const locatorParams = (0, _get_discover_locator_params.getDiscoverLocatorParams)(embeddable);
    await this.locator.navigate(locatorParams);
  }
  getDisplayName() {
    return _i18n.i18n.translate('discover.savedSearchEmbeddable.action.viewSavedSearch.displayName', {
      defaultMessage: 'Open in Discover'
    });
  }
  getIconType() {
    return 'inspect';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      capabilities
    } = this.application;
    const hasDiscoverPermissions = capabilities.discover.show || capabilities.discover.save;
    return compatibilityCheck(embeddable) && hasDiscoverPermissions;
  }
}
exports.ViewSavedSearchAction = ViewSavedSearchAction;