"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogsExplorerTabs = void 0;
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const emptyParams = {};
const LogsExplorerTabs = ({
  services,
  selectedTab
}) => {
  var _services$share;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const locators = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators;
  const discoverLocator = locators === null || locators === void 0 ? void 0 : locators.get(_common.DISCOVER_APP_LOCATOR);
  const logsExplorerLocator = locators === null || locators === void 0 ? void 0 : locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
  const discoverUrl = discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.getRedirectUrl(emptyParams);
  const logsExplorerUrl = logsExplorerLocator === null || logsExplorerLocator === void 0 ? void 0 : logsExplorerLocator.getRedirectUrl(emptyParams);
  const navigateToDiscover = createNavigateHandler(() => {
    if (selectedTab !== 'discover') {
      discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.navigate(emptyParams);
    }
  });
  const navigateToLogsExplorer = createNavigateHandler(() => {
    if (selectedTab !== 'logs-explorer') {
      logsExplorerLocator === null || logsExplorerLocator === void 0 ? void 0 : logsExplorerLocator.navigate(emptyParams);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    "data-test-subj": "logsExplorerTabs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'discover',
    href: discoverUrl,
    onClick: navigateToDiscover,
    css: {
      '.euiTab__content': {
        lineHeight: euiTheme.size.xxxl
      }
    },
    "data-test-subj": "discoverTab"
  }, _i18n.i18n.translate('discover.logsExplorerTabs.discover', {
    defaultMessage: 'Discover'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === 'logs-explorer',
    href: logsExplorerUrl,
    onClick: navigateToLogsExplorer,
    css: {
      '.euiTab__content': {
        lineHeight: euiTheme.size.xxxl
      }
    },
    "data-test-subj": "logsExplorerTab"
  }, _i18n.i18n.translate('discover.logsExplorerTabs.logsExplorer', {
    defaultMessage: 'Logs Explorer'
  })));
};

// eslint-disable-next-line import/no-default-export
exports.LogsExplorerTabs = LogsExplorerTabs;
var _default = exports.default = LogsExplorerTabs;
const isModifiedEvent = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;
const isLeftClickEvent = event => event.button === 0;
const createNavigateHandler = onClick => e => {
  if (isModifiedEvent(e) || !isLeftClickEvent(e)) {
    return;
  }
  e.preventDefault();
  onClick();
};