"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTourStepFooterAction = exports.DiscoverTourProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("../../../common");
var _use_discover_services = require("../../hooks/use_discover_services");
var _discover_tour_context = require("./discover_tour_context");
var _discover_tour_anchors = require("./discover_tour_anchors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MAX_WIDTH = 350;
const ADD_FIELDS_STEP = {
  anchor: _discover_tour_anchors.DISCOVER_TOUR_STEP_ANCHORS.addFields,
  title: _i18n.i18n.translate('discover.dscTour.stepAddFields.title', {
    defaultMessage: 'Add fields to the table'
  }),
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.dscTour.stepAddFields.description",
    defaultMessage: "Click {plusIcon} to add the fields that interest you.",
    values: {
      plusIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "plusInCircleFilled",
        color: "primary",
        "aria-label": "+"
      })
    }
  }),
  imageName: 'add_fields.gif',
  imageAltText: _i18n.i18n.translate('discover.dscTour.stepAddFields.imageAltText', {
    defaultMessage: 'In the Available fields list, click the plus icon to toggle a field into the document table.'
  })
};
const ORDER_TABLE_COLUMNS_STEP = {
  anchor: _discover_tour_anchors.DISCOVER_TOUR_STEP_ANCHORS.reorderColumns,
  title: _i18n.i18n.translate('discover.dscTour.stepReorderColumns.title', {
    defaultMessage: 'Order the table columns'
  }),
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.dscTour.stepReorderColumns.description",
    defaultMessage: "Drag columns to the order you want."
  }),
  imageName: 'reorder_columns.gif',
  imageAltText: _i18n.i18n.translate('discover.dscTour.stepReorderColumns.imageAltText', {
    defaultMessage: 'Use the Columns popover to drag the columns to the order you prefer.'
  })
};
const CHANGE_ROW_HEIGHT_STEP = {
  anchor: _discover_tour_anchors.DISCOVER_TOUR_STEP_ANCHORS.changeRowHeight,
  title: _i18n.i18n.translate('discover.dscTour.stepChangeRowHeight.title', {
    defaultMessage: 'Change the row height'
  }),
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.dscTour.stepChangeRowHeight.description",
    defaultMessage: "Adjust the number of lines to fit the contents."
  }),
  imageName: 'rows_per_line.gif',
  imageAltText: _i18n.i18n.translate('discover.dscTour.stepChangeRowHeight.imageAltText', {
    defaultMessage: 'Click the display options icon to adjust the row height to fit the contents.'
  })
};
const tourStepDefinitions = [ADD_FIELDS_STEP, ORDER_TABLE_COLUMNS_STEP, {
  anchor: _discover_tour_anchors.DISCOVER_TOUR_STEP_ANCHORS.sort,
  title: _i18n.i18n.translate('discover.dscTour.stepSort.title', {
    defaultMessage: 'Sort on one or more fields'
  }),
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.dscTour.stepSort.description",
    defaultMessage: "Use the column heading to sort on a single field, or the popover for multiple fields."
  }),
  imageName: 'sort.gif',
  imageAltText: _i18n.i18n.translate('discover.dscTour.stepSort.imageAltText', {
    defaultMessage: 'Click a column header and select the desired sort order. Adjust a multi-field sort using the fields sorted popover.'
  })
}, CHANGE_ROW_HEIGHT_STEP, {
  anchor: _discover_tour_anchors.DISCOVER_TOUR_STEP_ANCHORS.expandDocument,
  title: _i18n.i18n.translate('discover.dscTour.stepExpand.title', {
    defaultMessage: 'Expand documents'
  }),
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.dscTour.stepExpand.description",
    defaultMessage: "Click {expandIcon} to view, compare, and filter documents.",
    values: {
      expandIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "expand",
        color: "text",
        "aria-label": _i18n.i18n.translate('discover.dscTour.stepExpand.expandIconAriaLabel', {
          defaultMessage: 'Expand icon'
        })
      })
    }
  }),
  imageName: 'expand.gif',
  imageAltText: _i18n.i18n.translate('discover.dscTour.stepExpand.imageAltText', {
    defaultMessage: 'Click the expand icon to inspect and filter the fields in the document and view the document in context.'
  })
}];
const FIRST_STEP = 1;
const prepareTourSteps = (stepDefinitions, getAssetPath) => stepDefinitions.map((stepDefinition, index) => ({
  step: index + 1,
  anchor: stepDefinition.anchor,
  title: stepDefinition.title,
  maxWidth: MAX_WIDTH,
  content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, stepDefinition.content)), stepDefinition.imageName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: stepDefinition.imageAltText,
    src: getAssetPath(stepDefinition.imageName),
    size: "fullWidth"
  })))
}));
const findNextAvailableStep = (steps, currentTourStep) => {
  var _nextStep$step;
  const nextStep = steps.find(step => step.step > currentTourStep && typeof step.anchor === 'string' && document.querySelector(step.anchor));
  return (_nextStep$step = nextStep === null || nextStep === void 0 ? void 0 : nextStep.step) !== null && _nextStep$step !== void 0 ? _nextStep$step : null;
};
const tourConfig = {
  currentTourStep: FIRST_STEP,
  isTourActive: false,
  tourPopoverWidth: MAX_WIDTH,
  tourSubtitle: ''
};
const DiscoverTourProvider = ({
  children,
  isPlainRecord
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const prependToBasePath = services.core.http.basePath.prepend;
  const getAssetPath = (0, _react.useCallback)(imageName => {
    return prependToBasePath(`/plugins/${_common.PLUGIN_ID}/assets/discover_tour/${imageName}`);
  }, [prependToBasePath]);
  const tourSteps = (0, _react.useMemo)(() => isPlainRecord ? prepareTourSteps([ADD_FIELDS_STEP, ORDER_TABLE_COLUMNS_STEP, CHANGE_ROW_HEIGHT_STEP], getAssetPath) : prepareTourSteps(tourStepDefinitions, getAssetPath), [getAssetPath, isPlainRecord]);
  const [steps, actions, reducerState] = (0, _eui.useEuiTour)(tourSteps, tourConfig);
  const currentTourStep = reducerState.currentTourStep;
  const isTourActive = reducerState.isTourActive;
  const onStartTour = (0, _react.useCallback)(() => {
    actions.resetTour();
    actions.goToStep(FIRST_STEP, true);
  }, [actions]);
  const onNextTourStep = (0, _react.useCallback)(() => {
    const nextAvailableStep = findNextAvailableStep(steps, currentTourStep);
    if (nextAvailableStep) {
      actions.goToStep(nextAvailableStep);
    } else {
      actions.finishTour();
    }
  }, [actions, steps, currentTourStep]);
  const onFinishTour = (0, _react.useCallback)(() => {
    actions.finishTour();
  }, [actions]);
  const contextValue = (0, _react.useMemo)(() => ({
    onStartTour,
    onNextTourStep,
    onFinishTour
  }), [onStartTour, onNextTourStep, onFinishTour]);
  return /*#__PURE__*/_react.default.createElement(_discover_tour_context.DiscoverTourContext.Provider, {
    value: contextValue
  }, isTourActive && steps.map(step => /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({
    key: `step-${step.step}-is-${String(step.isStepOpen)}`
  }, step, {
    footerAction: /*#__PURE__*/_react.default.createElement(DiscoverTourStepFooterAction, {
      isLastStep: step.step === steps[steps.length - 1].step,
      onNextTourStep: onNextTourStep,
      onFinishTour: onFinishTour
    })
  }))), children);
};
exports.DiscoverTourProvider = DiscoverTourProvider;
const DiscoverTourStepFooterAction = ({
  isLastStep,
  onNextTourStep,
  onFinishTour
}) => {
  const actionButtonProps = {
    size: 's',
    color: 'success'
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center"
  }, !isLastStep && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    size: "xs",
    onClick: onFinishTour,
    "data-test-subj": "discoverTourButtonSkip"
  }, (0, _eui.EuiI18n)({
    token: 'core.euiTourFooter.skipTour',
    default: 'Skip tour'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isLastStep ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, actionButtonProps, {
    onClick: onFinishTour,
    "data-test-subj": "discoverTourButtonEnd"
  }), (0, _eui.EuiI18n)({
    token: 'core.euiTourFooter.endTour',
    default: 'End tour'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, actionButtonProps, {
    onClick: onNextTourStep,
    "data-test-subj": "discoverTourButtonNext"
  }), (0, _eui.EuiI18n)({
    token: 'core.euiTourFooter.nextStep',
    default: 'Next'
  }))));
};
exports.DiscoverTourStepFooterAction = DiscoverTourStepFooterAction;