"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridFlyout = DiscoverGridFlyout;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _use_discover_services = require("../../hooks/use_discover_services");
var _is_text_based_query = require("../../application/main/utils/is_text_based_query");
var _use_flyout_actions = require("./use_flyout_actions");
var _customizations = require("../../customizations");
var _discover_grid_flyout_actions = require("./discover_grid_flyout_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getIndexByDocId(hits, id) {
  return hits.findIndex(h => {
    return h.id === id;
  });
}
/**
 * Flyout displaying an expanded Elasticsearch document
 */
function DiscoverGridFlyout({
  hit,
  hits,
  dataView,
  columns,
  columnsMeta,
  savedSearchId,
  filters,
  query,
  onFilter,
  onClose,
  onRemoveColumn,
  onAddColumn,
  setExpandedDoc
}) {
  var _flyoutCustomization$, _flyoutCustomization$2;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const flyoutCustomization = (0, _customizations.useDiscoverCustomization)('flyout');
  const isPlainRecord = (0, _is_text_based_query.isTextBasedQuery)(query);
  // Get actual hit with updated highlighted searches
  const actualHit = (0, _react.useMemo)(() => (hits === null || hits === void 0 ? void 0 : hits.find(({
    id
  }) => id === (hit === null || hit === void 0 ? void 0 : hit.id))) || hit, [hit, hits]);
  const pageCount = (0, _react.useMemo)(() => hits ? hits.length : 0, [hits]);
  const activePage = (0, _react.useMemo)(() => {
    const id = hit.id;
    if (!hits || pageCount <= 1) {
      return -1;
    }
    return getIndexByDocId(hits, id);
  }, [hits, hit, pageCount]);
  const setPage = (0, _react.useCallback)(index => {
    if (hits && hits[index]) {
      setExpandedDoc(hits[index]);
    }
  }, [hits, setExpandedDoc]);
  const onKeyDown = (0, _react.useCallback)(ev => {
    const nodeName = (0, _lodash.get)(ev, 'target.nodeName', null);
    if (typeof nodeName === 'string' && nodeName.toLowerCase() === 'input') {
      return;
    }
    if (ev.key === _eui.keys.ARROW_LEFT || ev.key === _eui.keys.ARROW_RIGHT) {
      ev.preventDefault();
      ev.stopPropagation();
      setPage(activePage + (ev.key === _eui.keys.ARROW_RIGHT ? 1 : -1));
    }
  }, [activePage, setPage]);
  const {
    flyoutActions
  } = (0, _use_flyout_actions.useFlyoutActions)({
    actions: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.actions,
    dataView,
    rowIndex: hit.raw._index,
    rowId: hit.raw._id,
    columns,
    filters,
    savedSearchId
  });
  const addColumn = (0, _react.useCallback)(columnName => {
    onAddColumn(columnName);
    services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnAdded', {
      defaultMessage: `Column '{columnName}' was added`,
      values: {
        columnName
      }
    }));
  }, [onAddColumn, services.toastNotifications]);
  const removeColumn = (0, _react.useCallback)(columnName => {
    onRemoveColumn(columnName);
    services.toastNotifications.addSuccess(_i18n.i18n.translate('discover.grid.flyout.toastColumnRemoved', {
      defaultMessage: `Column '{columnName}' was removed`,
      values: {
        columnName
      }
    }));
  }, [onRemoveColumn, services.toastNotifications]);
  const renderDefaultContent = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    columns: columns,
    columnsMeta: columnsMeta,
    dataView: dataView,
    filter: onFilter,
    hit: actualHit,
    onAddColumn: addColumn,
    onRemoveColumn: removeColumn,
    textBasedHits: isPlainRecord ? hits : undefined,
    docViewsRegistry: flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.docViewsRegistry
  }), [actualHit, addColumn, columns, columnsMeta, dataView, hits, isPlainRecord, onFilter, removeColumn, flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.docViewsRegistry]);
  const contentActions = (0, _react.useMemo)(() => ({
    filter: onFilter,
    onAddColumn: addColumn,
    onRemoveColumn: removeColumn
  }), [onFilter, addColumn, removeColumn]);
  const bodyContent = flyoutCustomization !== null && flyoutCustomization !== void 0 && flyoutCustomization.Content ? /*#__PURE__*/_react.default.createElement(flyoutCustomization.Content, {
    actions: contentActions,
    doc: actualHit,
    renderDefaultContent: renderDefaultContent
  }) : renderDefaultContent();
  const defaultFlyoutTitle = isPlainRecord ? _i18n.i18n.translate('discover.grid.tableRow.docViewerTextBasedDetailHeading', {
    defaultMessage: 'Result'
  }) : _i18n.i18n.translate('discover.grid.tableRow.docViewerDetailHeading', {
    defaultMessage: 'Document'
  });
  const flyoutTitle = (_flyoutCustomization$ = flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.title) !== null && _flyoutCustomization$ !== void 0 ? _flyoutCustomization$ : defaultFlyoutTitle;
  const flyoutSize = (_flyoutCustomization$2 = flyoutCustomization === null || flyoutCustomization === void 0 ? void 0 : flyoutCustomization.size) !== null && _flyoutCustomization$2 !== void 0 ? _flyoutCustomization$2 : 'm';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    className: "DiscoverFlyout" // used to override the z-index of the flyout from SecuritySolution
    ,
    onClose: onClose,
    size: flyoutSize,
    "data-test-subj": "docTableDetailsFlyout",
    onKeyDown: onKeyDown,
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "m",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "docTableRowDetailsTitle",
    css: (0, _react2.css)`
                  white-space: nowrap;
                `
  }, /*#__PURE__*/_react.default.createElement("h2", null, flyoutTitle))), activePage !== -1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `dscDocNavigationPage-${activePage}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('discover.grid.flyout.documentNavigation', {
      defaultMessage: 'Document navigation'
    }),
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: setPage,
    compressed: true,
    "data-test-subj": "dscDocNavigation"
  }))), isPlainRecord || !flyoutActions.length ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_discover_grid_flyout_actions.DiscoverGridFlyoutActions, {
    flyoutActions: flyoutActions
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, bodyContent)));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = DiscoverGridFlyout;