"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverError = ({
  error
}) => {
  const {
    locator
  } = (0, _use_discover_services.useDiscoverServices)();
  const goToMain = async () => {
    await locator.navigate({});
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    paddingSize: "l",
    iconType: "warning",
    iconColor: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('discover.discoverError.title', {
      defaultMessage: 'Cannot load this page'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, error.message),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: goToMain
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.goToDiscoverButtonText",
      defaultMessage: "Go to Discover"
    }))
  });
};
exports.DiscoverError = DiscoverError;