"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateDefaults = getStateDefaults;
var _lodash = require("lodash");
var _public = require("@kbn/unified-histogram-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _sorting = require("../../../utils/sorting");
var _is_text_based_query = require("./is_text_based_query");
var _get_valid_view_mode = require("./get_valid_view_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getDefaultColumns(savedSearch, uiSettings) {
  if (savedSearch.columns && savedSearch.columns.length > 0) {
    return [...savedSearch.columns];
  }
  if (uiSettings.get(_discoverUtils.SEARCH_FIELDS_FROM_SOURCE) && (0, _lodash.isEqual)(uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING), [])) {
    return ['_source'];
  }
  return [...uiSettings.get(_discoverUtils.DEFAULT_COLUMNS_SETTING)];
}
function getStateDefaults({
  savedSearch,
  services
}) {
  var _savedSearch$sort;
  const {
    searchSource
  } = savedSearch;
  const {
    data,
    uiSettings,
    storage
  } = services;
  const dataView = searchSource.getField('index');
  const query = searchSource.getField('query') || data.query.queryString.getDefaultQuery();
  const isTextBasedQueryMode = (0, _is_text_based_query.isTextBasedQuery)(query);
  const sort = (0, _sorting.getSortArray)((_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [], dataView, isTextBasedQueryMode);
  const columns = getDefaultColumns(savedSearch, uiSettings);
  const chartHidden = (0, _public.getChartHidden)(storage, 'discover');
  const defaultState = {
    query,
    sort: !sort.length ? (0, _sorting.getDefaultSort)(dataView, uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING, 'desc'), uiSettings.get(_discoverUtils.DOC_HIDE_TIME_COLUMN_SETTING, false), isTextBasedQueryMode) : sort,
    columns,
    index: isTextBasedQueryMode ? undefined : dataView === null || dataView === void 0 ? void 0 : dataView.id,
    interval: 'auto',
    filters: (0, _lodash.cloneDeep)(searchSource.getOwnField('filter')),
    hideChart: typeof chartHidden === 'boolean' ? chartHidden : undefined,
    viewMode: undefined,
    hideAggregatedPreview: undefined,
    savedQuery: undefined,
    rowHeight: undefined,
    headerRowHeight: undefined,
    rowsPerPage: undefined,
    sampleSize: undefined,
    grid: undefined,
    breakdownField: undefined
  };
  if (savedSearch.grid) {
    defaultState.grid = savedSearch.grid;
  }
  if (savedSearch.hideChart !== undefined) {
    defaultState.hideChart = savedSearch.hideChart;
  }
  if (savedSearch.rowHeight !== undefined) {
    defaultState.rowHeight = savedSearch.rowHeight;
  }
  if (savedSearch.headerRowHeight !== undefined) {
    defaultState.headerRowHeight = savedSearch.headerRowHeight;
  }
  if (savedSearch.viewMode) {
    defaultState.viewMode = (0, _get_valid_view_mode.getValidViewMode)({
      viewMode: savedSearch.viewMode,
      isTextBasedQueryMode
    });
  }
  if (savedSearch.hideAggregatedPreview) {
    defaultState.hideAggregatedPreview = savedSearch.hideAggregatedPreview;
  }
  if (savedSearch.rowsPerPage) {
    defaultState.rowsPerPage = savedSearch.rowsPerPage;
  }
  if (savedSearch.sampleSize) {
    defaultState.sampleSize = savedSearch.sampleSize;
  }
  if (savedSearch.breakdownField) {
    defaultState.breakdownField = savedSearch.breakdownField;
  }
  return defaultState;
}