"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViewByTextBasedQueryLang = getDataViewByTextBasedQueryLang;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function getDataViewByTextBasedQueryLang(query, currentDataView, services) {
  let indexPatternFromQuery = '';
  if ('sql' in query) {
    indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromSQLQuery)(query.sql);
  }
  if ('esql' in query) {
    indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  }
  if (currentDataView !== null && currentDataView !== void 0 && currentDataView.isPersisted() || indexPatternFromQuery !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern())) {
    var _dataViewObj$fields$g;
    const dataViewObj = await (0, _esqlUtils.getESQLAdHocDataview)(indexPatternFromQuery, services.dataViews);

    // If the indexPatternFromQuery is empty string means that the user used either the ROW or SHOW META / SHOW INFO commands
    // we don't want to add the @timestamp field in this case https://github.com/elastic/kibana/issues/163417
    if (indexPatternFromQuery && ((_dataViewObj$fields$g = dataViewObj.fields.getByName('@timestamp')) === null || _dataViewObj$fields$g === void 0 ? void 0 : _dataViewObj$fields$g.type) === 'date') {
      dataViewObj.timeFieldName = '@timestamp';
    }
    return dataViewObj;
  }
  return currentDataView;
}