"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlTracking = useUrlTracking;
var _react = require("react");
var _use_discover_services = require("../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Enable/disable kbn url tracking (That's the URL used when selecting Discover in the side menu)
 */
function useUrlTracking(savedSearchContainer) {
  const {
    urlTracker
  } = (0, _use_discover_services.useDiscoverServices)();
  (0, _react.useEffect)(() => {
    const subscription = savedSearchContainer.getCurrent$().subscribe(savedSearch => {
      const dataView = savedSearch.searchSource.getField('index');
      if (!dataView) {
        return;
      }
      const trackingEnabled = Boolean(dataView.isPersisted() || savedSearch.id);
      urlTracker.setTrackingEnabled(trackingEnabled);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [savedSearchContainer, urlTracker]);
}