"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertResultsToast = exports.displayPossibleDocsDiffInfoAlert = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const displayPossibleDocsDiffInfoAlert = toastNotifications => {
  const infoTitle = _i18n.i18n.translate('discover.viewAlert.documentsMayVaryInfoTitle', {
    defaultMessage: 'Displayed documents may vary'
  });
  const infoDescription = _i18n.i18n.translate('discover.viewAlert.documentsMayVaryInfoDescription', {
    defaultMessage: `The displayed documents might differ from the documents that triggered the alert.
         Some documents might have been added or deleted.`
  });
  toastNotifications.addInfo({
    title: infoTitle,
    text: infoDescription
  });
};
exports.displayPossibleDocsDiffInfoAlert = displayPossibleDocsDiffInfoAlert;
const useAlertResultsToast = ({
  isAlertResults,
  toastNotifications
}) => {
  (0, _react.useEffect)(() => {
    if (isAlertResults) {
      displayPossibleDocsDiffInfoAlert(toastNotifications);
    }
  }, [isAlertResults, toastNotifications]);
};
exports.useAlertResultsToast = useAlertResultsToast;