"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavLinks = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _show_open_search_panel = require("./show_open_search_panel");
var _get_sharing_data = require("../../../../utils/get_sharing_data");
var _on_save_search = require("./on_save_search");
var _open_alerts_popover = require("./open_alerts_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper function to build the top nav links
 */
const getTopNavLinks = ({
  dataView,
  services,
  state,
  onOpenInspector,
  isTextBased,
  adHocDataViews,
  topNavCustomization
}) => {
  var _topNavCustomization$, _topNavCustomization$2, _defaultMenu$newItem, _defaultMenu$openItem, _defaultMenu$shareIte, _services$capabilitie, _services$capabilitie2, _defaultMenu$alertsIt, _defaultMenu$inspectI, _defaultMenu$saveItem;
  const alerts = {
    id: 'alerts',
    label: _i18n.i18n.translate('discover.localMenu.localMenu.alertsTitle', {
      defaultMessage: 'Alerts'
    }),
    description: _i18n.i18n.translate('discover.localMenu.alertsDescription', {
      defaultMessage: 'Alerts'
    }),
    run: async anchorElement => {
      (0, _open_alerts_popover.openAlertsPopover)({
        anchorElement,
        services,
        stateContainer: state,
        adHocDataViews,
        isPlainRecord: isTextBased
      });
    },
    testId: 'discoverAlertsButton'
  };
  const newSearch = {
    id: 'new',
    label: _i18n.i18n.translate('discover.localMenu.localMenu.newSearchTitle', {
      defaultMessage: 'New'
    }),
    description: _i18n.i18n.translate('discover.localMenu.newSearchDescription', {
      defaultMessage: 'New Search'
    }),
    run: () => services.locator.navigate({}),
    testId: 'discoverNewButton'
  };
  const saveSearch = {
    id: 'save',
    label: _i18n.i18n.translate('discover.localMenu.saveTitle', {
      defaultMessage: 'Save'
    }),
    description: _i18n.i18n.translate('discover.localMenu.saveSearchDescription', {
      defaultMessage: 'Save Search'
    }),
    testId: 'discoverSaveButton',
    iconType: 'save',
    emphasize: true,
    run: anchorElement => {
      (0, _on_save_search.onSaveSearch)({
        savedSearch: state.savedSearchState.getState(),
        services,
        state,
        onClose: () => {
          anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
        }
      });
    }
  };
  const openSearch = {
    id: 'open',
    label: _i18n.i18n.translate('discover.localMenu.openTitle', {
      defaultMessage: 'Open'
    }),
    description: _i18n.i18n.translate('discover.localMenu.openSavedSearchDescription', {
      defaultMessage: 'Open Saved Search'
    }),
    testId: 'discoverOpenButton',
    run: () => (0, _show_open_search_panel.showOpenSearchPanel)({
      onOpenSavedSearch: state.actions.onOpenSavedSearch,
      services
    })
  };
  const shareSearch = {
    id: 'share',
    label: _i18n.i18n.translate('discover.localMenu.shareTitle', {
      defaultMessage: 'Share'
    }),
    description: _i18n.i18n.translate('discover.localMenu.shareSearchDescription', {
      defaultMessage: 'Share Search'
    }),
    testId: 'shareTopNavButton',
    run: async anchorElement => {
      if (!services.share) return;
      const savedSearch = state.savedSearchState.getState();
      const searchSourceSharingData = await (0, _get_sharing_data.getSharingData)(savedSearch.searchSource, state.appState.getState(), services, isTextBased);
      const {
        locator,
        notifications
      } = services;
      const appState = state.appState.getState();
      const {
        timefilter
      } = services.data.query.timefilter;
      const timeRange = timefilter.getTime();
      const refreshInterval = timefilter.getRefreshInterval();
      const filters = services.filterManager.getFilters();

      // Share -> Get links -> Snapshot
      const params = {
        ...appState,
        ...(savedSearch.id ? {
          savedSearchId: savedSearch.id
        } : {}),
        ...(dataView !== null && dataView !== void 0 && dataView.isPersisted() ? {
          dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
        } : {
          dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec()
        }),
        filters,
        timeRange,
        refreshInterval
      };
      const relativeUrl = locator.getRedirectUrl(params);

      // This logic is duplicated from `relativeToAbsolute` (for bundle size reasons). Ultimately, this should be
      // replaced when https://github.com/elastic/kibana/issues/153323 is implemented.
      const link = document.createElement('a');
      link.setAttribute('href', relativeUrl);
      const shareableUrl = link.href;

      // Share -> Get links -> Saved object
      let shareableUrlForSavedObject = await locator.getUrl({
        savedSearchId: savedSearch.id
      }, {
        absolute: true
      });

      // UrlPanelContent forces a '_g' parameter in the saved object URL:
      // https://github.com/elastic/kibana/blob/a30508153c1467b1968fb94faf1debc5407f61ea/src/plugins/share/public/components/url_panel_content.tsx#L230
      // Since our locator doesn't add the '_g' parameter if it's not needed, UrlPanelContent
      // will interpret it as undefined and add '?_g=' to the URL, which is invalid in Discover,
      // so instead we add an empty object for the '_g' parameter to the URL.
      shareableUrlForSavedObject = (0, _public.setStateToKbnUrl)('_g', {}, undefined, shareableUrlForSavedObject);
      services.share.toggleShareContextMenu({
        anchorElement,
        allowEmbed: false,
        allowShortUrl: !!services.capabilities.discover.createShortUrl,
        shareableUrl,
        shareableUrlForSavedObject,
        shareableUrlLocatorParams: {
          locator,
          params
        },
        objectId: savedSearch.id,
        objectType: 'search',
        sharingData: {
          isTextBased,
          locatorParams: [{
            id: locator.id,
            params
          }],
          ...searchSourceSharingData,
          // CSV reports can be generated without a saved search so we provide a fallback title
          title: savedSearch.title || _i18n.i18n.translate('discover.localMenu.fallbackReportTitle', {
            defaultMessage: 'Untitled discover search'
          })
        },
        isDirty: !savedSearch.id || state.appState.hasChanged(),
        showPublicUrlSwitch: _get_sharing_data.showPublicUrlSwitch,
        onClose: () => {
          anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
        },
        toasts: notifications.toasts
      });
    }
  };
  const inspectSearch = {
    id: 'inspect',
    label: _i18n.i18n.translate('discover.localMenu.inspectTitle', {
      defaultMessage: 'Inspect'
    }),
    description: _i18n.i18n.translate('discover.localMenu.openInspectorForSearchDescription', {
      defaultMessage: 'Open Inspector for search'
    }),
    testId: 'openInspectorButton',
    run: () => {
      onOpenInspector();
    }
  };
  const defaultMenu = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : topNavCustomization.defaultMenu;
  const entries = [...((_topNavCustomization$ = topNavCustomization === null || topNavCustomization === void 0 ? void 0 : (_topNavCustomization$2 = topNavCustomization.getMenuItems) === null || _topNavCustomization$2 === void 0 ? void 0 : _topNavCustomization$2.call(topNavCustomization)) !== null && _topNavCustomization$ !== void 0 ? _topNavCustomization$ : [])];
  if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$newItem = defaultMenu.newItem) !== null && _defaultMenu$newItem !== void 0 && _defaultMenu$newItem.disabled)) {
    var _defaultMenu$newItem$, _defaultMenu$newItem2;
    entries.push({
      data: newSearch,
      order: (_defaultMenu$newItem$ = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$newItem2 = defaultMenu.newItem) === null || _defaultMenu$newItem2 === void 0 ? void 0 : _defaultMenu$newItem2.order) !== null && _defaultMenu$newItem$ !== void 0 ? _defaultMenu$newItem$ : 100
    });
  }
  if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$openItem = defaultMenu.openItem) !== null && _defaultMenu$openItem !== void 0 && _defaultMenu$openItem.disabled)) {
    var _defaultMenu$openItem2, _defaultMenu$openItem3;
    entries.push({
      data: openSearch,
      order: (_defaultMenu$openItem2 = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$openItem3 = defaultMenu.openItem) === null || _defaultMenu$openItem3 === void 0 ? void 0 : _defaultMenu$openItem3.order) !== null && _defaultMenu$openItem2 !== void 0 ? _defaultMenu$openItem2 : 200
    });
  }
  if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$shareIte = defaultMenu.shareItem) !== null && _defaultMenu$shareIte !== void 0 && _defaultMenu$shareIte.disabled)) {
    var _defaultMenu$shareIte2, _defaultMenu$shareIte3;
    entries.push({
      data: shareSearch,
      order: (_defaultMenu$shareIte2 = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$shareIte3 = defaultMenu.shareItem) === null || _defaultMenu$shareIte3 === void 0 ? void 0 : _defaultMenu$shareIte3.order) !== null && _defaultMenu$shareIte2 !== void 0 ? _defaultMenu$shareIte2 : 300
    });
  }
  if (services.triggersActionsUi && (_services$capabilitie = services.capabilities.management) !== null && _services$capabilitie !== void 0 && (_services$capabilitie2 = _services$capabilitie.insightsAndAlerting) !== null && _services$capabilitie2 !== void 0 && _services$capabilitie2.triggersActions && !(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$alertsIt = defaultMenu.alertsItem) !== null && _defaultMenu$alertsIt !== void 0 && _defaultMenu$alertsIt.disabled)) {
    var _defaultMenu$alertsIt2, _defaultMenu$alertsIt3;
    entries.push({
      data: alerts,
      order: (_defaultMenu$alertsIt2 = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$alertsIt3 = defaultMenu.alertsItem) === null || _defaultMenu$alertsIt3 === void 0 ? void 0 : _defaultMenu$alertsIt3.order) !== null && _defaultMenu$alertsIt2 !== void 0 ? _defaultMenu$alertsIt2 : 400
    });
  }
  if (!(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$inspectI = defaultMenu.inspectItem) !== null && _defaultMenu$inspectI !== void 0 && _defaultMenu$inspectI.disabled)) {
    var _defaultMenu$inspectI2, _defaultMenu$inspectI3;
    entries.push({
      data: inspectSearch,
      order: (_defaultMenu$inspectI2 = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$inspectI3 = defaultMenu.inspectItem) === null || _defaultMenu$inspectI3 === void 0 ? void 0 : _defaultMenu$inspectI3.order) !== null && _defaultMenu$inspectI2 !== void 0 ? _defaultMenu$inspectI2 : 500
    });
  }
  if (services.capabilities.discover.save && !(defaultMenu !== null && defaultMenu !== void 0 && (_defaultMenu$saveItem = defaultMenu.saveItem) !== null && _defaultMenu$saveItem !== void 0 && _defaultMenu$saveItem.disabled)) {
    var _defaultMenu$saveItem2, _defaultMenu$saveItem3;
    entries.push({
      data: saveSearch,
      order: (_defaultMenu$saveItem2 = defaultMenu === null || defaultMenu === void 0 ? void 0 : (_defaultMenu$saveItem3 = defaultMenu.saveItem) === null || _defaultMenu$saveItem3 === void 0 ? void 0 : _defaultMenu$saveItem3.order) !== null && _defaultMenu$saveItem2 !== void 0 ? _defaultMenu$saveItem2 : 600
    });
  }
  return entries.sort((a, b) => a.order - b.order).map(entry => entry.data);
};
exports.getTopNavLinks = getTopNavLinks;