"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestionDefault = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoResultsSuggestionDefault = ({
  dataView
}) => {
  const dataViewName = dataView === null || dataView === void 0 ? void 0 : dataView.getName();
  const dataViewPattern = dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "discoverNoResultsCheckIndices"
  }, dataViewName && dataViewPattern ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.noDocumentsOrCheckIndicesAndPermissionsDescription",
    defaultMessage: "Make sure that the data view {dataViewName} with index pattern {dataViewPattern} has matching indices and documents and that you have permission to view them.",
    values: {
      dataViewName: /*#__PURE__*/_react.default.createElement("strong", null, dataViewName),
      dataViewPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataViewPattern)
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.noDocumentsOrCheckPermissionsDescription",
    defaultMessage: "Make sure that you have permission to view the indices and that they contain documents."
  }));
};
exports.NoResultsSuggestionDefault = NoResultsSuggestionDefault;