"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverHistogram = void 0;
var _use_query_subscriber = require("@kbn/unified-field-list/src/hooks/use_query_subscriber");
var _public = require("@kbn/unified-histogram-plugin/public");
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _customizations = require("../../../../customizations");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _add_log = require("../../../../utils/add_log");
var _discover_internal_state_container = require("../../services/discover_internal_state_container");
var _discover_data_state_container = require("../../services/discover_data_state_container");
var _discover_state_provider = require("../../services/discover_state_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_TEXT_BASED_COLUMNS = [];
const EMPTY_FILTERS = [];
const useDiscoverHistogram = ({
  stateContainer,
  inspectorAdapters,
  hideChart,
  isPlainRecord
}) => {
  const services = (0, _use_discover_services.useDiscoverServices)();
  const savedSearchData$ = stateContainer.dataState.data$;
  const savedSearchState = (0, _discover_state_provider.useSavedSearch)();

  /**
   * API initialization
   */

  const [unifiedHistogram, ref] = (0, _react.useState)();
  const [isSuggestionLoading, setIsSuggestionLoading] = (0, _react.useState)(false);
  const getCreationOptions = (0, _react.useCallback)(() => {
    const {
      hideChart: chartHidden,
      interval: timeInterval,
      breakdownField
    } = stateContainer.appState.getState();
    return {
      localStorageKeyPrefix: 'discover',
      disableAutoFetching: true,
      initialState: {
        chartHidden,
        timeInterval,
        breakdownField,
        totalHitsStatus: _public.UnifiedHistogramFetchStatus.loading,
        totalHitsResult: undefined
      }
    };
  }, [stateContainer.appState]);

  /**
   * Sync Unified Histogram state with Discover state
   */

  (0, _react.useEffect)(() => {
    var _createUnifiedHistogr;
    const subscription = (_createUnifiedHistogr = createUnifiedHistogramStateObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createUnifiedHistogr === void 0 ? void 0 : _createUnifiedHistogr.subscribe(changes => {
      const {
        lensRequestAdapter,
        ...stateChanges
      } = changes;
      const appState = stateContainer.appState.getState();
      const oldState = {
        hideChart: appState.hideChart,
        interval: appState.interval,
        breakdownField: appState.breakdownField
      };
      const newState = {
        ...oldState,
        ...stateChanges
      };
      if ('lensRequestAdapter' in changes) {
        inspectorAdapters.lensRequests = lensRequestAdapter;
      }
      if (!(0, _lodash.isEqual)(oldState, newState)) {
        stateContainer.appState.update(newState);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [inspectorAdapters, stateContainer.appState, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Sync URL query params with Unified Histogram
   */

  (0, _react.useEffect)(() => {
    const subscription = createAppStateObservable(stateContainer.appState.state$).subscribe(changes => {
      if ('breakdownField' in changes) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setBreakdownField(changes.breakdownField);
      }
      if ('timeInterval' in changes && changes.timeInterval) {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setTimeInterval(changes.timeInterval);
      }
      if ('chartHidden' in changes && typeof changes.chartHidden === 'boolean') {
        unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.setChartHidden(changes.chartHidden);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [stateContainer.appState.state$, unifiedHistogram]);

  /**
   * Total hits
   */

  const setTotalHitsError = (0, _react.useMemo)(() => (0, _use_saved_search_messages.sendErrorTo)(savedSearchData$.totalHits$), [savedSearchData$.totalHits$]);
  (0, _react.useEffect)(() => {
    var _createTotalHitsObser;
    const subscription = (_createTotalHitsObser = createTotalHitsObservable(unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$)) === null || _createTotalHitsObser === void 0 ? void 0 : _createTotalHitsObser.subscribe(({
      status,
      result
    }) => {
      const {
        recordRawType,
        result: totalHitsResult
      } = savedSearchData$.totalHits$.getValue();
      if (recordRawType === _discover_data_state_container.RecordRawType.PLAIN) {
        // ignore histogram's total hits updates for text-based records as Discover manages them during docs fetching
        return;
      }
      if (result instanceof Error) {
        // Set totalHits$ to an error state
        setTotalHitsError(result);
        return;
      }
      if ((status === _public.UnifiedHistogramFetchStatus.loading || status === _public.UnifiedHistogramFetchStatus.uninitialized) && totalHitsResult && typeof result !== 'number') {
        // ignore the histogram initial loading state if discover state already has a total hits value
        return;
      }

      // Sync the totalHits$ observable with the unified histogram state
      savedSearchData$.totalHits$.next({
        fetchStatus: status.toString(),
        result,
        recordRawType
      });
      if (status !== _public.UnifiedHistogramFetchStatus.complete || typeof result !== 'number') {
        return;
      }

      // Check the hits count to set a partial or no results state
      (0, _use_saved_search_messages.checkHitCount)(savedSearchData$.main$, result);
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [savedSearchData$.main$, savedSearchData$.totalHits$, setTotalHitsError, unifiedHistogram === null || unifiedHistogram === void 0 ? void 0 : unifiedHistogram.state$]);

  /**
   * Request params
   */
  const {
    query,
    filters
  } = (0, _use_query_subscriber.useQuerySubscriber)({
    data: services.data
  });
  const customFilters = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.customFilters);
  const timefilter = services.data.query.timefilter.timefilter;
  const timeRange = timefilter.getAbsoluteTime();
  const relativeTimeRange = (0, _useObservable.default)(timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => timefilter.getTime())), timefilter.getTime());

  // When in text based language mode, update the data view, query, and
  // columns only when documents are done fetching so the Lens suggestions
  // don't frequently change, such as when the user modifies the table
  // columns, which would trigger unnecessary refetches.
  const textBasedFetchComplete$ = (0, _react.useMemo)(() => createFetchCompleteObservable(stateContainer), [stateContainer]);
  const [initialTextBasedProps] = (0, _react.useState)(() => getUnifiedHistogramPropsForTextBased({
    documentsValue: savedSearchData$.documents$.getValue(),
    savedSearch: stateContainer.savedSearchState.getState()
  }));
  const {
    dataView: textBasedDataView,
    query: textBasedQuery,
    columns: textBasedColumns
  } = (0, _useObservable.default)(textBasedFetchComplete$, initialTextBasedProps);
  (0, _react.useEffect)(() => {
    if (!isPlainRecord) {
      return;
    }
    const fetchStart = stateContainer.dataState.fetch$.subscribe(() => {
      if (!skipRefetch.current) {
        setIsSuggestionLoading(true);
      }
    });
    const fetchComplete = textBasedFetchComplete$.subscribe(() => {
      setIsSuggestionLoading(false);
    });
    return () => {
      fetchStart.unsubscribe();
      fetchComplete.unsubscribe();
    };
  }, [isPlainRecord, stateContainer.dataState.fetch$, textBasedFetchComplete$]);

  /**
   * Data fetching
   */

  const skipRefetch = (0, _react.useRef)();

  // Skip refetching when showing the chart since Lens will
  // automatically fetch when the chart is shown
  (0, _react.useEffect)(() => {
    if (skipRefetch.current === undefined) {
      skipRefetch.current = false;
    } else {
      skipRefetch.current = !hideChart;
    }
  }, [hideChart]);

  // Handle unified histogram refetching
  (0, _react.useEffect)(() => {
    if (!unifiedHistogram) {
      return;
    }
    let fetch$;

    // When in text based language mode, we refetch under two conditions:
    // 1. When the current Lens suggestion changes. This syncs the visualization
    //    with the user's selection.
    // 2. When the documents are done fetching. This is necessary because we don't
    //    have access to the latest columns until after the documents are fetched,
    //    which are required to get the latest Lens suggestion, which would trigger
    //    a refetch anyway and result in multiple unnecessary fetches.
    if (isPlainRecord) {
      fetch$ = (0, _rxjs.merge)(createCurrentSuggestionObservable(unifiedHistogram.state$).pipe((0, _rxjs.map)(() => 'lens')), textBasedFetchComplete$.pipe((0, _rxjs.map)(() => 'discover'))).pipe((0, _rxjs.debounceTime)(50));
    } else {
      fetch$ = stateContainer.dataState.fetch$.pipe((0, _rxjs.filter)(({
        options
      }) => !options.fetchMore),
      // don't update histogram for "Load more" in the grid
      (0, _rxjs.map)(() => 'discover'));
    }
    const subscription = fetch$.subscribe(source => {
      if (!skipRefetch.current) {
        if (source === 'discover') (0, _add_log.addLog)('Unified Histogram - Discover refetch');
        if (source === 'lens') (0, _add_log.addLog)('Unified Histogram - Lens suggestion refetch');
        unifiedHistogram.refetch();
      }
      skipRefetch.current = false;
    });

    // triggering the initial request for total hits hook
    if (!isPlainRecord && !skipRefetch.current) {
      unifiedHistogram.refetch();
    }
    return () => {
      subscription.unsubscribe();
    };
  }, [isPlainRecord, stateContainer.dataState.fetch$, textBasedFetchComplete$, unifiedHistogram]);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const histogramCustomization = (0, _customizations.useDiscoverCustomization)('unified_histogram');
  const filtersMemoized = (0, _react.useMemo)(() => {
    const allFilters = [...(filters !== null && filters !== void 0 ? filters : []), ...customFilters];
    return allFilters.length ? allFilters : EMPTY_FILTERS;
  }, [filters, customFilters]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const timeRangeMemoized = (0, _react.useMemo)(() => timeRange, [timeRange === null || timeRange === void 0 ? void 0 : timeRange.from, timeRange === null || timeRange === void 0 ? void 0 : timeRange.to]);
  const onVisContextChanged = (0, _react.useCallback)((nextVisContext, externalVisContextStatus) => {
    switch (externalVisContextStatus) {
      case _public.UnifiedHistogramExternalVisContextStatus.manuallyCustomized:
        // if user customized the visualization manually
        // (only this action should trigger Unsaved changes badge)
        stateContainer.savedSearchState.updateVisContext({
          nextVisContext
        });
        stateContainer.internalState.transitions.setOverriddenVisContextAfterInvalidation(undefined);
        break;
      case _public.UnifiedHistogramExternalVisContextStatus.automaticallyOverridden:
        // if the visualization was invalidated as incompatible and rebuilt
        // (it will be used later for saving the visualization via Save button)
        stateContainer.internalState.transitions.setOverriddenVisContextAfterInvalidation(nextVisContext);
        break;
      case _public.UnifiedHistogramExternalVisContextStatus.automaticallyCreated:
      case _public.UnifiedHistogramExternalVisContextStatus.applied:
        // clearing the value in the internal state so we don't use it during saved search saving
        stateContainer.internalState.transitions.setOverriddenVisContextAfterInvalidation(undefined);
        break;
      case _public.UnifiedHistogramExternalVisContextStatus.unknown:
        // using `{}` to overwrite the value inside the saved search SO during saving
        stateContainer.internalState.transitions.setOverriddenVisContextAfterInvalidation({});
        break;
    }
  }, [stateContainer]);
  return {
    ref,
    getCreationOptions,
    services,
    dataView: isPlainRecord ? textBasedDataView : dataView,
    query: isPlainRecord ? textBasedQuery : query,
    filters: filtersMemoized,
    timeRange: timeRangeMemoized,
    relativeTimeRange,
    columns: isPlainRecord ? textBasedColumns : undefined,
    onFilter: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onFilter,
    onBrushEnd: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onBrushEnd,
    withDefaultActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.withDefaultActions,
    disabledActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.disabledActions,
    isChartLoading: isSuggestionLoading,
    // visContext should be in sync with current query
    externalVisContext: isPlainRecord && (0, _public.canImportVisContext)(savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext) ? savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext : undefined,
    onVisContextChanged: isPlainRecord ? onVisContextChanged : undefined
  };
};

// Use pairwise to diff the previous and current state (starting with undefined to ensure
// pairwise triggers after a single emission), and return an object containing only the
// changed properties. By only including the changed properties, we avoid accidentally
// overwriting other state properties that may have been updated between the time this
// obersverable was triggered and the time the state changes are applied.
exports.useDiscoverHistogram = useDiscoverHistogram;
const createUnifiedHistogramStateObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.lensRequestAdapter) !== curr.lensRequestAdapter) {
      changes.lensRequestAdapter = curr.lensRequestAdapter;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.chartHidden) !== curr.chartHidden) {
      changes.hideChart = curr.chartHidden;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.timeInterval) !== curr.timeInterval) {
      changes.interval = curr.timeInterval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createAppStateObservable = state$ => {
  return state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.breakdownField) !== curr.breakdownField) {
      changes.breakdownField = curr.breakdownField;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.interval) !== curr.interval) {
      changes.timeInterval = curr.interval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.hideChart) !== curr.hideChart) {
      changes.chartHidden = curr.hideChart;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createFetchCompleteObservable = stateContainer => {
  return stateContainer.dataState.data$.documents$.pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => prev.fetchStatus === curr.fetchStatus), (0, _rxjs.filter)(({
    fetchStatus
  }) => [_types.FetchStatus.COMPLETE, _types.FetchStatus.ERROR].includes(fetchStatus)), (0, _rxjs.map)(documentsValue => {
    return getUnifiedHistogramPropsForTextBased({
      documentsValue,
      savedSearch: stateContainer.savedSearchState.getState()
    });
  }));
};
const createTotalHitsObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => ({
    status: state.totalHitsStatus,
    result: state.totalHitsResult
  })), (0, _rxjs.distinctUntilChanged)((prev, curr) => prev.status === curr.status && prev.result === curr.result));
};
const createCurrentSuggestionObservable = state$ => {
  return state$.pipe((0, _rxjs.map)(state => state.currentSuggestionContext), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual));
};
function getUnifiedHistogramPropsForTextBased({
  documentsValue,
  savedSearch
}) {
  const columns = (documentsValue === null || documentsValue === void 0 ? void 0 : documentsValue.textBasedQueryColumns) || EMPTY_TEXT_BASED_COLUMNS;
  const nextProps = {
    dataView: savedSearch.searchSource.getField('index'),
    query: savedSearch.searchSource.getField('query'),
    columns
  };
  (0, _add_log.addLog)('[UnifiedHistogram] delayed next props for text-based', nextProps);
  return nextProps;
}