"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentsLayoutProps = getDocumentsLayoutProps;
exports.getPlainRecordLayoutProps = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/inspector-plugin/common");
var _addonActions = require("@storybook/addon-actions");
var _history = require("history");
var _discoverUtils = require("@kbn/discover-utils");
var _mocks__ = require("@kbn/discover-utils/src/__mocks__");
var _types = require("../../../../types");
var _discover_data_state_container = require("../../../services/discover_data_state_container");
var _discover_state = require("../../../services/discover_state");
var _with_discover_services = require("../../../../../__mocks__/__storybook_mocks__/with_discover_services");
var _customization_context = require("../../../../../customizations/__mocks__/customization_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const documentObservables = {
  main$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    foundDocuments: true
  }),
  documents$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    result: (0, _discoverUtils.buildDataTableRecordList)(_mocks__.esHitsMock)
  }),
  availableFields$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    fields: []
  }),
  totalHits$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    result: Number(_mocks__.esHitsMock.length)
  }),
  fetch$: new _rxjs.Observable()
};
const plainRecordObservables = {
  main$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    foundDocuments: true,
    recordRawType: _discover_data_state_container.RecordRawType.PLAIN
  }),
  documents$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    result: (0, _discoverUtils.buildDataTableRecordList)(_mocks__.esHitsMock),
    recordRawType: _discover_data_state_container.RecordRawType.PLAIN
  }),
  availableFields$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    fields: [],
    recordRawType: _discover_data_state_container.RecordRawType.PLAIN
  }),
  totalHits$: new _rxjs.BehaviorSubject({
    fetchStatus: _types.FetchStatus.COMPLETE,
    recordRawType: _discover_data_state_container.RecordRawType.PLAIN
  })
};
const getCommonProps = () => {
  const searchSourceMock = {};
  const savedSearchMock = {};
  return {
    inspectorAdapters: {
      requests: new _common.RequestAdapter()
    },
    onChangeDataView: (0, _addonActions.action)('change the data view'),
    onUpdateQuery: (0, _addonActions.action)('update the query'),
    savedSearch: savedSearchMock,
    savedSearchRefetch$: new _rxjs.Subject(),
    searchSource: searchSourceMock,
    stateContainer: {
      setAppState: (0, _addonActions.action)('Set app state'),
      appState: {
        getState: () => ({
          interval: 'auto'
        }),
        setState: (0, _addonActions.action)('Set app state')
      }
    },
    setExpandedDoc: (0, _addonActions.action)('opening an expanded doc')
  };
};
function getSavedSearch(dataView) {
  return {
    searchSource: {
      getField: value => {
        if (value === 'index') {
          return dataView;
        }
      },
      getOwnField: () => {
        return {
          query: ''
        };
      },
      createChild: () => {
        return {
          fetch$: () => new _rxjs.Observable()
        };
      }
    }
  };
}
function getDocumentsLayoutProps(dataView) {
  const stateContainer = (0, _discover_state.getDiscoverStateContainer)({
    history: (0, _history.createHashHistory)(),
    savedSearch: getSavedSearch(dataView),
    services: _with_discover_services.services,
    customizationContext: _customization_context.mockCustomizationContext
  });
  stateContainer.appState.set({
    columns: ['name', 'message', 'bytes'],
    sort: dataView.timeFieldName ? [['date', 'desc']] : [['name', 'desc']],
    query: {
      language: 'kuery',
      query: ''
    },
    filters: [],
    hideChart: true
  });
  stateContainer.actions.setDataView(dataView);
  stateContainer.dataState.data$ = documentObservables;
  return {
    ...getCommonProps(),
    stateContainer
  };
}
const getPlainRecordLayoutProps = dataView => {
  const stateContainer = (0, _discover_state.getDiscoverStateContainer)({
    history: (0, _history.createHashHistory)(),
    savedSearch: getSavedSearch(dataView),
    services: _with_discover_services.services,
    customizationContext: _customization_context.mockCustomizationContext
  });
  stateContainer.appState.set({
    columns: ['name', 'message', 'bytes'],
    sort: [['date', 'desc']],
    query: {
      esql: 'FROM "kibana_sample_data_ecommerce"'
    },
    filters: []
  });
  stateContainer.actions.setDataView(dataView);
  stateContainer.dataState.data$ = plainRecordObservables;
  return {
    ...getCommonProps(),
    stateContainer
  };
};
exports.getPlainRecordLayoutProps = getPlainRecordLayoutProps;