"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentExplorerUpdateCallout = exports.CALLOUT_STATE_KEY = void 0;
var _react = _interopRequireWildcard(require("react"));
require("./document_explorer_callout.scss");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_tour = require("../../../../components/discover_tour");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CALLOUT_STATE_KEY = exports.CALLOUT_STATE_KEY = 'discover:docExplorerUpdateCalloutClosed';
const getStoredCalloutState = storage => {
  const calloutClosed = storage.get(CALLOUT_STATE_KEY);
  return Boolean(calloutClosed);
};
const updateStoredCalloutState = (newState, storage) => {
  storage.set(CALLOUT_STATE_KEY, newState);
};

/**
 * The callout that's displayed when Document explorer is enabled
 */
const DocumentExplorerUpdateCallout = () => {
  const {
    storage,
    capabilities
  } = (0, _use_discover_services.useDiscoverServices)();
  const [calloutClosed, setCalloutClosed] = (0, _react.useState)(getStoredCalloutState(storage));
  const {
    onStartTour
  } = (0, _discover_tour.useDiscoverTourContext)();
  const onCloseCallout = (0, _react.useCallback)(() => {
    updateStoredCalloutState(true, storage);
    setCalloutClosed(true);
  }, [storage]);
  if (calloutClosed || !capabilities.advancedSettings.save) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "dscDocumentExplorerTourCallout",
    className: "dscDocumentExplorerCallout",
    title: /*#__PURE__*/_react.default.createElement(CalloutTitle, {
      onCloseCallout: onCloseCallout
    }),
    iconType: "tableDensityNormal",
    heading: "h3",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerUpdateCallout.description",
    defaultMessage: "Add relevant fields, reorder and sort columns, resize rows, and more in the document table."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onStartTour,
    "data-test-subj": "discoverTakeTourButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerUpdateCallout.takeTourButtonLabel",
    defaultMessage: "Take the tour"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: onCloseCallout,
    "data-test-subj": "document-explorer-update-callout-dismiss-button"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerUpdateCallout.dismissButtonLabel",
    defaultMessage: "Dismiss"
  })))));
};
exports.DocumentExplorerUpdateCallout = DocumentExplorerUpdateCallout;
function CalloutTitle({
  onCloseCallout
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerUpdateCallout.title",
    defaultMessage: "Get the best look at your search results"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('discover.docExplorerUpdateCallout.closeButtonAriaLabel', {
      defaultMessage: 'Close'
    }),
    onClick: onCloseCallout,
    type: "button",
    iconType: "cross"
  })));
}