"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asPairs = asPairs;
exports.generateIntervals = generateIntervals;
var _public = require("@kbn/data-plugin/public");
var _context = require("../services/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Generate a sequence of pairs from the iterable that looks like
 * `[[x_0, x_1], [x_1, x_2], [x_2, x_3], ..., [x_(n-1), x_n]]`.
 */
function* asPairs(iterable) {
  let currentPair = [];
  for (const value of iterable) {
    currentPair = [...currentPair, value].slice(-2);
    if (currentPair.length === 2) {
      yield currentPair;
    }
  }
}

/**
 * Returns a iterable containing intervals `[start,end]` for Elasticsearch date range queries
 * depending on type (`successors` or `predecessors`) and sort (`asc`, `desc`) these are ascending or descending intervals.
 */
function generateIntervals(offsets, startTime, type, sort) {
  const offsetSign = sort === _public.SortDirection.asc && type === _context.SurrDocType.SUCCESSORS || sort === _public.SortDirection.desc && type === _context.SurrDocType.PREDECESSORS ? 1 : -1;
  // ending with `null` opens the last interval
  return asPairs([...offsets.map(offset => startTime + offset * offsetSign), null]);
}