"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsStats = getDataStreamsStats;
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamsStats(options) {
  const {
    esClient,
    type,
    datasetQuery
  } = options;
  const matchingDataStreamsStats = await _services.dataStreamService.getMatchingDataStreamsStats(esClient, {
    type: type !== null && type !== void 0 ? type : '*',
    dataset: datasetQuery ? `*${datasetQuery}*` : '*'
  });
  const mappedDataStreams = matchingDataStreamsStats.map(dataStream => {
    var _dataStream$store_siz;
    return {
      name: dataStream.data_stream,
      size: (_dataStream$store_siz = dataStream.store_size) === null || _dataStream$store_siz === void 0 ? void 0 : _dataStream$store_siz.toString(),
      sizeBytes: dataStream.store_size_bytes,
      lastActivity: dataStream.maximum_timestamp
    };
  });
  return {
    items: mappedDataStreams
  };
}