"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDatasets = generateDatasets;
var _data_stream_stat = require("../../common/data_streams_stats/data_stream_stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateDatasets(dataStreamStats = [], degradedDocStats = [], integrations) {
  if (!dataStreamStats.length && !integrations.length) {
    return [];
  }
  const integrationMap = integrations.reduce((integrationMapAcc, integration) => {
    return {
      ...integrationMapAcc,
      ...Object.keys(integration.datasets).reduce((datasetsAcc, dataset) => Object.assign(datasetsAcc, {
        [dataset]: {
          integration,
          title: integration.datasets[dataset]
        }
      }), {})
    };
  }, {});
  if (!dataStreamStats.length) {
    return degradedDocStats.map(degradedDocStat => _data_stream_stat.DataStreamStat.fromDegradedDocStat({
      degradedDocStat,
      integrationMap
    }));
  }
  const degradedMap = degradedDocStats.reduce((degradedMapAcc, {
    dataset,
    percentage,
    count
  }) => Object.assign(degradedMapAcc, {
    [dataset]: {
      percentage,
      count
    }
  }), {});
  return dataStreamStats === null || dataStreamStats === void 0 ? void 0 : dataStreamStats.map(dataStream => {
    var _integrationMap$dataS, _integrationMap$dataS2;
    return {
      ...dataStream,
      title: ((_integrationMap$dataS = integrationMap[dataStream.name]) === null || _integrationMap$dataS === void 0 ? void 0 : _integrationMap$dataS.title) || dataStream.title,
      integration: (_integrationMap$dataS2 = integrationMap[dataStream.name]) === null || _integrationMap$dataS2 === void 0 ? void 0 : _integrationMap$dataS2.integration,
      degradedDocs: degradedMap[dataStream.rawName] || dataStream.degradedDocs
    };
  });
}