"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsStatsClient = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _integration = require("../../../common/data_streams_stats/integration");
var _api_types = require("../../../common/api_types");
var _constants = require("../../../common/constants");
var _data_streams_stats = require("../../../common/data_streams_stats");
var _data_stream_stat = require("../../../common/data_streams_stats/data_stream_stat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamsStatsClient {
  constructor(http) {
    this.http = http;
  }
  async getDataStreamsStats(params = {
    type: _constants.DEFAULT_DATASET_TYPE
  }) {
    const response = await this.http.get('/internal/dataset_quality/data_streams/stats', {
      query: params
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data streams stats: ${error}`);
    });
    const {
      dataStreamsStats
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsStatsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data streams stats response: ${message}`))(response);
    return dataStreamsStats.map(_data_stream_stat.DataStreamStat.create);
  }
  async getDataStreamsDegradedStats(params) {
    const response = await this.http.get('/internal/dataset_quality/data_streams/degraded_docs', {
      query: {
        ...params,
        type: _constants.DEFAULT_DATASET_TYPE
      }
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data streams degraded stats: ${error}`);
    });
    const {
      degradedDocs
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsDegradedDocsStatsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data streams degraded docs stats response: ${message}`))(response);
    return degradedDocs;
  }
  async getDataStreamsEstimatedDataInBytes(params) {
    const response = await this.http.get(`/internal/dataset_quality/data_streams/estimated_data`, {
      ...params
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch data streams estimated data in bytes": ${error}`);
    });
    const dataStreamsEstimatedDataInBytes = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsEstimatedDataInBytesResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode data streams estimated data in bytes response: ${message}"`))(response);
    return dataStreamsEstimatedDataInBytes;
  }
  async getIntegrations(params = {
    type: _constants.DEFAULT_DATASET_TYPE
  }) {
    const response = await this.http.get('/internal/dataset_quality/integrations', {
      query: params
    }).catch(error => {
      throw new _data_streams_stats.GetDataStreamsStatsError(`Failed to fetch integrations: ${error}`);
    });
    const {
      integrations
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getIntegrationsResponseRt, message => new _data_streams_stats.GetDataStreamsStatsError(`Failed to decode integrations response: ${message}`))(response);
    return integrations.map(_integration.Integration.create);
  }
}
exports.DataStreamsStatsClient = DataStreamsStatsClient;