"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLinkToLogsExplorer = void 0;
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLinkToLogsExplorer = ({
  dataStreamStat,
  query
}) => {
  var _dataStreamStat$integ;
  const {
    services: {
      share
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    timeRange: {
      from,
      to
    }
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const params = {
    dataset: dataStreamStat.name,
    timeRange: {
      from,
      to
    },
    integration: (_dataStreamStat$integ = dataStreamStat.integration) === null || _dataStreamStat$integ === void 0 ? void 0 : _dataStreamStat$integ.name,
    query,
    filterControls: {
      namespace: {
        mode: 'include',
        values: [dataStreamStat.namespace]
      }
    }
  };
  const singleDatasetLocator = share.url.locators.get(_deeplinksObservability.SINGLE_DATASET_LOCATOR_ID);
  const urlToLogsExplorer = singleDatasetLocator === null || singleDatasetLocator === void 0 ? void 0 : singleDatasetLocator.getRedirectUrl(params);
  const navigateToLogsExplorer = () => {
    singleDatasetLocator === null || singleDatasetLocator === void 0 ? void 0 : singleDatasetLocator.navigate(params);
  };
  const logsExplorerLinkProps = (0, _routerUtils.getRouterLinkProps)({
    href: urlToLogsExplorer,
    onClick: navigateToLogsExplorer
  });
  return logsExplorerLinkProps;
};
exports.useLinkToLogsExplorer = useLinkToLogsExplorer;