"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityFlyout = void 0;
var _react = require("@xstate/react");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityFlyout = () => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    dataset: dataStreamStat,
    datasetDetails: dataStreamDetails,
    insightsTimeRange,
    breakdownField
  } = (0, _react.useSelector)(service, state => state.context.flyout);
  const {
    timeRange
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const dataStreamDetailsLoading = (0, _react.useSelector)(service, state => state.matches('datasets.loaded.flyoutOpen.fetching') || state.matches('flyout.initializing.dataStreamDetails.fetching'));
  return {
    dataStreamStat,
    dataStreamDetails,
    dataStreamDetailsLoading,
    fieldFormats,
    timeRange: insightsTimeRange !== null && insightsTimeRange !== void 0 ? insightsTimeRange : timeRange,
    breakdownField
  };
};
exports.useDatasetQualityFlyout = useDatasetQualityFlyout;