"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityPercentageIndicator = QualityPercentageIndicator;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("./helpers");
var _indicator = require("./indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FEW_DEGRADED_DOCS_THRESHOLD = 0.0005;
function QualityPercentageIndicator({
  percentage,
  degradedDocsCount
}) {
  const quality = (0, _helpers.mapPercentageToQuality)(percentage);
  const isFewDegradedDocsAvailable = percentage && percentage < FEW_DEGRADED_DOCS_THRESHOLD;
  const description = isFewDegradedDocsAvailable ? /*#__PURE__*/_react.default.createElement(DatasetWithFewDegradedDocs, {
    degradedDocsCount: degradedDocsCount
  }) : /*#__PURE__*/_react.default.createElement(DatasetWithManyDegradedDocs, {
    percentage: percentage
  });
  return /*#__PURE__*/_react.default.createElement(_indicator.QualityIndicator, {
    quality: quality,
    description: description
  });
}
const DatasetWithFewDegradedDocs = ({
  degradedDocsCount
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, "~0%", ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.datasetQuality.fewDegradedDocsTooltip', {
      defaultMessage: '{degradedDocsCount} degraded docs in this dataset.',
      values: {
        degradedDocsCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    size: "s"
  })));
};
const DatasetWithManyDegradedDocs = ({
  percentage
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: percentage
  }), "%");
};