"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Flyout;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
var _dataset_summary = require("./dataset_summary");
var _header = require("./header");
var _integration_summary = require("./integration_summary");
var _degraded_docs = require("./degraded_docs_trend/degraded_docs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Flyout({
  dataset,
  closeFlyout
}) {
  const {
    dataStreamStat,
    dataStreamDetails,
    dataStreamDetailsLoading,
    fieldFormats,
    timeRange,
    breakdownField
  } = (0, _hooks.useDatasetQualityFlyout)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    ownFocus: false,
    "data-component-name": 'datasetQualityFlyout',
    "data-test-subj": "datasetQualityFlyout"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    dataStreamStat: dataset
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "datasetQualityFlyoutBody"
  }, /*#__PURE__*/_react.default.createElement(_degraded_docs.DegradedDocs, {
    dataStream: dataStreamStat === null || dataStreamStat === void 0 ? void 0 : dataStreamStat.rawName,
    timeRange: timeRange,
    breakdownField: breakdownField
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), dataStreamDetailsLoading ? /*#__PURE__*/_react.default.createElement(_dataset_summary.DatasetSummaryLoading, null) : dataStreamStat ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_dataset_summary.DatasetSummary, {
    dataStreamDetails: dataStreamDetails,
    fieldFormats: fieldFormats
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), dataStreamStat.integration && /*#__PURE__*/_react.default.createElement(_integration_summary.IntegrationSummary, {
    integration: dataStreamStat.integration
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "datasetQualityFlyoutButton",
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left"
  }, _translations.flyoutCancelText))))));
}
module.exports = exports.default;