"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocsChart = DegradedDocsChart;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/embeddable-plugin/common");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _translations = require("../../../../common/translations");
var _utils = require("../../../utils");
var _lens_attributes = require("./lens_attributes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 180;
const DISABLED_ACTIONS = ['ACTION_CUSTOMIZE_PANEL', 'ACTION_CONFIGURE_IN_LENS', 'create-ml-ad-job-action'];
function DegradedDocsChart({
  dataStream,
  timeRange,
  lastReloadTime,
  dataView,
  breakdownDataViewField
}) {
  const {
    services: {
      lens
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isChartLoading, setIsChartLoading] = (0, _react.useState)(undefined);
  const [attributes, setAttributes] = (0, _react.useState)(undefined);
  const handleChartLoading = (0, _react.useCallback)(isLoading => {
    setIsChartLoading(isLoading);
  }, []);
  const filterQuery = `_index: ${dataStream !== null && dataStream !== void 0 ? dataStream : 'match-none'}`;
  (0, _react.useEffect)(() => {
    if (dataView) {
      const lensAttributes = (0, _lens_attributes.getLensAttributes)(euiTheme.colors.danger, dataView, breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name);
      setAttributes(lensAttributes);
    }
  }, [lens, euiTheme.colors.danger, dataView, breakdownDataViewField]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      minHeight: CHART_HEIGHT
    },
    direction: "column",
    justifyContent: "center",
    alignItems: isChartLoading === undefined ? 'center' : undefined
  }, !attributes ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    title: _translations.flyoutDegradedDocsTrendText,
    size: "l",
    mono: true
  }) : /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    id: "datasetQualityFlyoutDegradedDocsTrend",
    style: {
      height: CHART_HEIGHT
    },
    css: lensEmbeddableComponentStyles,
    viewMode: _common.ViewMode.VIEW,
    hidePanelTitles: true,
    disabledActions: DISABLED_ACTIONS,
    timeRange: timeRange,
    attributes: attributes,
    withDefaultActions: true,
    disableTriggers: false,
    lastReloadRequestTime: lastReloadTime,
    query: {
      language: 'kuery',
      query: filterQuery || ''
    },
    onLoad: handleChartLoading
  }))));
}
const lensEmbeddableComponentStyles = (0, _react2.css)`
  .lnsExpressionRenderer__component {
    margin-left: -16px;

    .expExpressionRenderer__expression {
      padding: 0 !important;
    }
  }
`;