"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocs = DegradedDocs;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-histogram-plugin/public");
var _hooks = require("../../../hooks");
var _utils = require("../../../../common/utils");
var _constants = require("../../../../common/constants");
var _translations = require("../../../../common/translations");
var _context = require("../../dataset_quality/context");
var _degraded_docs_chart = require("./degraded_docs_chart");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_REFRESH = {
  value: 60000,
  pause: false
};
function DegradedDocs({
  dataStream,
  timeRange = {
    ..._constants.DEFAULT_TIME_RANGE,
    refresh: DEFAULT_REFRESH
  },
  breakdownField
}) {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    dataView
  } = (0, _hooks.useCreateDataView)({
    indexPatternString: getDataViewIndexPattern(dataStream)
  });
  const [breakdownDataViewField, setBreakdownDataViewField] = (0, _react.useState)(undefined);
  const [lastReloadTime, setLastReloadTime] = (0, _react.useState)(Date.now());
  (0, _react.useEffect)(() => {
    if (dataView) {
      const dataViewField = getDataViewField(dataView, breakdownField);
      if (dataViewField) {
        const isFieldBreakable = (0, _public.fieldSupportsBreakdown)(dataViewField);
        if (isFieldBreakable) {
          setBreakdownDataViewField(dataViewField);
        } else {
          setBreakdownDataViewField(undefined);
          // TODO: If needed, notify user that the field is not breakable
        }
      } else {
        setBreakdownDataViewField(undefined);
      }
    }
  }, [dataView, breakdownField]);
  const handleRefresh = (0, _react.useCallback)(_refreshProps => {
    setLastReloadTime(Date.now());
  }, []);
  const handleTimeChange = (0, _react.useCallback)(durationRange => {
    var _timeRange$refresh;
    service.send({
      type: 'UPDATE_INSIGHTS_TIME_RANGE',
      timeRange: {
        from: durationRange.start,
        to: durationRange.end,
        refresh: (_timeRange$refresh = timeRange.refresh) !== null && _timeRange$refresh !== void 0 ? _timeRange$refresh : DEFAULT_REFRESH
      }
    });
  }, [service, timeRange.refresh]);
  const handleBreakdownFieldChange = (0, _react.useCallback)(field => {
    var _field$name;
    service.send({
      type: 'BREAKDOWN_FIELD_CHANGE',
      breakdownField: (_field$name = field === null || field === void 0 ? void 0 : field.name) !== null && _field$name !== void 0 ? _field$name : null
    });
  }, [service]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            flex-grow: 1;
          `,
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _translations.flyoutDegradedDocsText)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: degradedDocsTooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    color: "subdued",
    type: "questionInCircle",
    className: "eui-alignTop"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            flex-wrap: wrap-reverse;
          `,
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, dataView ? /*#__PURE__*/_react.default.createElement(_public.UnifiedBreakdownFieldSelector, {
    dataView: dataView,
    breakdown: {
      field: breakdownDataViewField
    },
    onBreakdownFieldChange: handleBreakdownFieldChange
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: 160,
    height: 32
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
              flex-grow: 0;
              margin-left: auto;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    width: "auto",
    compressed: true,
    isLoading: false,
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: handleTimeChange,
    onRefresh: handleRefresh,
    isQuickSelectOnly: false,
    showUpdateButton: "iconOnly",
    updateButtonProps: {
      fill: false
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_degraded_docs_chart.DegradedDocsChart, {
    dataStream: dataStream,
    timeRange: timeRange,
    lastReloadTime: lastReloadTime,
    dataView: dataView,
    breakdownDataViewField: breakdownDataViewField
  }));
}
const degradedDocsTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.flyoutDegradedDocsTooltip",
  defaultMessage: "The percentage of degraded documents \u2014documents with the {ignoredProperty} property\u2014 in your dataset.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});
function getDataViewIndexPattern(dataStream) {
  return dataStream ? `${(0, _utils.indexNameToDataStreamParts)(dataStream).type}-*-*` : _constants.DEFAULT_LOGS_DATA_VIEW;
}
function getDataViewField(dataView, fieldName) {
  return fieldName && dataView ? dataView.fields.find(field => field.name === fieldName) : undefined;
}