"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Table = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../common/translations");
var _hooks = require("../../../hooks");
var _descriptive_switch = require("../../common/descriptive_switch");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Flyout = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../../flyout/flyout'))));
const Table = () => {
  const {
    sort,
    onTableChange,
    pagination,
    renderedItems,
    columns,
    loading,
    resultsCount,
    selectedDataset,
    closeFlyout,
    showInactiveDatasets,
    showFullDatasetNames,
    toggleInactiveDatasets,
    toggleFullDatasetNames
  } = (0, _hooks.useDatasetQualityTable)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.tableSummary",
    defaultMessage: "Showing {items} Datasets",
    values: {
      items: resultsCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_descriptive_switch.DescriptiveSwitch, {
    label: _translations.fullDatasetNameLabel,
    checked: showFullDatasetNames,
    tooltipText: _translations.fullDatasetNameDescription,
    onToggle: toggleFullDatasetNames
  }), /*#__PURE__*/_react.default.createElement(_descriptive_switch.DescriptiveSwitch, {
    label: _translations.inactiveDatasetsLabel,
    checked: showInactiveDatasets,
    tooltipText: _translations.inactiveDatasetsDescription,
    onToggle: toggleInactiveDatasets
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      height: 2
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "auto",
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityTable",
    isSelectable: true,
    rowProps: {
      'data-test-subj': 'datasetQualityTableRow'
    },
    items: renderedItems,
    columns: columns,
    loading: loading,
    noItemsMessage: loading ? _translations.loadingDatasetsText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.noDatasetsTitle),
      hasBorder: false,
      titleSize: "m"
    })
  }), selectedDataset && /*#__PURE__*/_react.default.createElement(Flyout, {
    dataset: selectedDataset,
    closeFlyout: closeFlyout
  }));
};

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Table = Table;
var _default = exports.default = Table;