"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastDayDataPlaceholder = LastDayDataPlaceholder;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LastDayDataPlaceholder({
  title,
  tooltip,
  value,
  isLoading
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltip
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, _translations.summaryPanelLast24hText)), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    "data-test-subj": `datasetQuality-${title}-loading`
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `datasetQualityDatasetHealthKpi-${title}`,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, value))));
}