"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EstimatedData = EstimatedData;
var _react = _interopRequireDefault(require("react"));
var _formatters = require("@kbn/formatters");
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
var _last_day_data_placeholder = require("./last_day_data_placeholder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EstimatedData() {
  const {
    estimatedData,
    isEstimatedDataLoading
  } = (0, _hooks.useSummaryPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_last_day_data_placeholder.LastDayDataPlaceholder, {
    title: _translations.summaryPanelEstimatedDataText,
    tooltip: _translations.summaryPanelEstimatedDataTooltipText,
    value: (0, _formatters.formatBytes)(estimatedData.estimatedDataInBytes),
    isLoading: isEstimatedDataLoading
  });
}