"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.betaBadgeLabel = exports.betaBadgeDescription = void 0;
exports.default = Header;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const betaBadgeLabel = exports.betaBadgeLabel = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeLabel', {
  defaultMessage: 'Beta'
});
const betaBadgeDescription = exports.betaBadgeDescription = _i18n.i18n.translate('xpack.datasetQuality.betaBadgeDescription', {
  defaultMessage: 'This feature is currently in beta. If you encounter any bugs or have feedback, we’d love to hear from you. Please open a support issue and/or visit our discussion forum.'
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Header() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", null, _translations.datasetQualityAppTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: betaBadgeLabel,
    title: betaBadgeLabel,
    tooltipContent: betaBadgeDescription
  })))));
}