"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Filters;
var _eui = require("@elastic/eui");
var _dataService = require("@kbn/data-service");
var _react = _interopRequireWildcard(require("react"));
var _use_dataset_quality_filters = require("../../../hooks/use_dataset_quality_filters");
var _use_kibana = require("../../../utils/use_kibana");
var _filter_bar = require("./filter_bar");
var _integrations_selector = require("./integrations_selector");
var _namespaces_selector = require("./namespaces_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Filters() {
  const {
    timeRange,
    onTimeChange,
    onRefresh,
    onRefreshChange,
    isLoading,
    integrations,
    namespaces,
    onIntegrationsChange,
    onNamespacesChange,
    selectedQuery,
    onQueryChange
  } = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const {
    services: {
      uiSettings
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const timePickerQuickRanges = uiSettings.get(_dataService.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = (0, _react.useMemo)(() => timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  })), [timePickerQuickRanges]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityFiltersContainer",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_filter_bar.FilterBar, {
    query: selectedQuery,
    onQueryChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_integrations_selector.IntegrationsSelector, {
    isLoading: isLoading,
    integrations: integrations,
    onIntegrationsChange: onIntegrationsChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_namespaces_selector.NamespacesSelector, {
    isLoading: isLoading,
    namespaces: namespaces,
    onNamespacesChange: onNamespacesChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: timeRange.from,
    end: timeRange.to,
    onTimeChange: onTimeChange,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    commonlyUsedRanges: commonlyUsedRanges,
    showUpdateButton: true,
    isPaused: timeRange.refresh.pause,
    refreshInterval: timeRange.refresh.value
  })));
}
module.exports = exports.default;