"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationRt = exports.integrationIconRt = exports.integrationDashboardsRT = exports.getIntegrationsResponseRt = exports.getIntegrationDashboardsResponseRt = exports.getDataStreamsStatsResponseRt = exports.getDataStreamsEstimatedDataInBytesResponseRt = exports.getDataStreamsDetailsResponseRt = exports.getDataStreamsDegradedDocsStatsResponseRt = exports.degradedDocsRt = exports.dataStreamsEstimatedDataInBytesRT = exports.dataStreamStatRt = exports.dataStreamDetailsRt = exports.dashboardRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dataStreamStatRt = exports.dataStreamStatRt = rt.intersection([rt.type({
  name: rt.string
}), rt.partial({
  size: rt.string,
  sizeBytes: rt.number,
  lastActivity: rt.number,
  integration: rt.string
})]);
const dashboardRT = exports.dashboardRT = rt.type({
  id: rt.string,
  title: rt.string
});
const integrationDashboardsRT = exports.integrationDashboardsRT = rt.type({
  dashboards: rt.array(dashboardRT)
});
const getIntegrationDashboardsResponseRt = exports.getIntegrationDashboardsResponseRt = rt.exact(integrationDashboardsRT);
const integrationIconRt = exports.integrationIconRt = rt.intersection([rt.type({
  path: rt.string,
  src: rt.string
}), rt.partial({
  title: rt.string,
  size: rt.string,
  type: rt.string
})]);
const integrationRt = exports.integrationRt = rt.intersection([rt.type({
  name: rt.string
}), rt.partial({
  title: rt.string,
  version: rt.string,
  icons: rt.array(integrationIconRt),
  datasets: rt.record(rt.string, rt.string),
  dashboards: rt.array(dashboardRT)
})]);
const getIntegrationsResponseRt = exports.getIntegrationsResponseRt = rt.exact(rt.type({
  integrations: rt.array(integrationRt)
}));
const degradedDocsRt = exports.degradedDocsRt = rt.type({
  dataset: rt.string,
  percentage: rt.number,
  count: rt.number
});
const dataStreamDetailsRt = exports.dataStreamDetailsRt = rt.partial({
  createdOn: rt.number,
  lastActivity: rt.number
});
const getDataStreamsStatsResponseRt = exports.getDataStreamsStatsResponseRt = rt.exact(rt.type({
  dataStreamsStats: rt.array(dataStreamStatRt)
}));
const getDataStreamsDegradedDocsStatsResponseRt = exports.getDataStreamsDegradedDocsStatsResponseRt = rt.exact(rt.type({
  degradedDocs: rt.array(degradedDocsRt)
}));
const getDataStreamsDetailsResponseRt = exports.getDataStreamsDetailsResponseRt = rt.exact(dataStreamDetailsRt);
const dataStreamsEstimatedDataInBytesRT = exports.dataStreamsEstimatedDataInBytesRT = rt.type({
  estimatedDataInBytes: rt.union([rt.number, rt.null]) // Null in serverless: https://github.com/elastic/kibana/issues/178954
});
const getDataStreamsEstimatedDataInBytesResponseRt = exports.getDataStreamsEstimatedDataInBytesResponseRt = rt.exact(dataStreamsEstimatedDataInBytesRT);