"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api = require("./api");
var _get_max_bytes = require("./application/common/util/get_max_bytes");
var _register_home = require("./register_home");
var _embeddables = require("./application/index_data_visualizer/embeddables");
var _kibana_services = require("./kibana_services");
var _locator = require("./application/index_data_visualizer/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataVisualizerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "resultsLinks", {
      fileBeat: {
        enabled: true
      }
    });
    const resultsLinks = initializerContext.config.get().resultLinks;
    if (resultsLinks !== undefined) {
      var _resultsLinks$fileBea, _resultsLinks$fileBea2;
      this.resultsLinks.fileBeat.enabled = (_resultsLinks$fileBea = (_resultsLinks$fileBea2 = resultsLinks.fileBeat) === null || _resultsLinks$fileBea2 === void 0 ? void 0 : _resultsLinks$fileBea2.enabled) !== null && _resultsLinks$fileBea !== void 0 ? _resultsLinks$fileBea : true;
    }
  }
  setup(core, plugins) {
    if (plugins.home) {
      (0, _register_home.registerHomeAddData)(plugins.home, this.resultsLinks);
      (0, _register_home.registerHomeFeatureCatalogue)(plugins.home);
    }
    (0, _embeddables.registerEmbeddables)(plugins.embeddable, core);
    plugins.share.url.locators.create(new _locator.IndexDataVisualizerLocatorDefinition());
  }
  start(core, plugins) {
    (0, _kibana_services.setStartServices)(core, plugins);
    const {
      getFileDataVisualizerComponent,
      getIndexDataVisualizerComponent,
      getDataDriftComponent
    } = (0, _api.getComponents)(this.resultsLinks);
    return {
      getFileDataVisualizerComponent,
      getIndexDataVisualizerComponent,
      getDataDriftComponent,
      getMaxBytesFormatted: _get_max_bytes.getMaxBytesFormatted
    };
  }
}
exports.DataVisualizerPlugin = DataVisualizerPlugin;