"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSafeESQLName = exports.getESQLPercentileQueryArray = exports.PERCENTS = void 0;
exports.isESQLQuery = isESQLQuery;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function to escape special characters for field names used in ES|QL queries.
 * https://www.elastic.co/guide/en/elasticsearch/reference/current/esql-syntax.html#esql-identifiers
 * @param str
 * @returns "`str`"
 **/
const getSafeESQLName = str => {
  return `\`${str}\``;
};
exports.getSafeESQLName = getSafeESQLName;
function isESQLQuery(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['esql']);
}
const PERCENTS = exports.PERCENTS = Array.from(Array(_constants.MAX_PERCENT / _constants.PERCENTILE_SPACING + 1), (_, i) => i * _constants.PERCENTILE_SPACING);
const getESQLPercentileQueryArray = (fieldName, percents = PERCENTS) => percents.map(p => `${getSafeESQLName(`${fieldName}_p${p}`)} = PERCENTILE(${getSafeESQLName(fieldName)}, ${p})`);
exports.getESQLPercentileQueryArray = getESQLPercentileQueryArray;