"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerGridEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DataVisualizerGridEmbeddableFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _constants.DATA_VISUALIZER_GRID_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: 'data_visualizer_grid',
      getDisplayName: () => 'Data Visualizer Grid'
    }]);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return false;
  }
  canCreateNew() {
    return false;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.dataVisualizer.index.components.grid.displayName', {
      defaultMessage: 'Data visualizer grid'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.dataVisualizer.index.components.grid.description', {
      defaultMessage: 'Visualize data'
    });
  }
  async getServices() {
    const [coreStart, pluginsStart] = await this.getStartServices();
    return [coreStart, pluginsStart];
  }
  async create(initialInput, parent) {
    const [coreStart, pluginsStart] = await this.getServices();
    const {
      DataVisualizerGridEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./grid_embeddable')));
    return new DataVisualizerGridEmbeddable(initialInput, [coreStart, pluginsStart], parent);
  }
}
exports.DataVisualizerGridEmbeddableFactory = DataVisualizerGridEmbeddableFactory;