"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDataVisualizerViewWrapper = exports.DataVisualizerGridEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/embeddable-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _constants = require("./constants");
var _embeddable_loading_fallback = require("./embeddable_loading_fallback");
var _embeddable_esql_field_stats_table = require("./embeddable_esql_field_stats_table");
var _embeddable_field_stats_table = require("./embeddable_field_stats_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isESQLDataVisualizerEmbeddableInput(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['esql']) && input.esql === true;
}
function isDataVisualizerEmbeddableInput(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['dataView']);
}
const IndexDataVisualizerViewWrapper = props => {
  const {
    embeddableInput,
    onOutputChange
  } = props;
  const input = (0, _useObservable.default)(embeddableInput);
  if (isESQLDataVisualizerEmbeddableInput(input)) {
    return /*#__PURE__*/_react.default.createElement(_embeddable_esql_field_stats_table.EmbeddableESQLFieldStatsTableWrapper, {
      input: input,
      onOutputChange: onOutputChange
    });
  }
  if (isDataVisualizerEmbeddableInput(input)) {
    return /*#__PURE__*/_react.default.createElement(_embeddable_field_stats_table.EmbeddableFieldStatsTableWrapper, {
      input: input,
      onOutputChange: onOutputChange
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorTitle",
        defaultMessage: "Error loading embeddable"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorDescription",
        defaultMessage: "There was an error loading the embeddable. Please check if all the required input is valid."
      }))
    });
  }
};
exports.IndexDataVisualizerViewWrapper = IndexDataVisualizerViewWrapper;
class DataVisualizerGridEmbeddable extends _public.Embeddable {
  constructor(initialInput, services, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reload$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "type", _constants.DATA_VISUALIZER_GRID_EMBEDDABLE_TYPE);
    this.services = services;
  }
  render(node) {
    super.render(node);
    this.node = node;
    const I18nContext = this.services[0].i18n.Context;
    const services = {
      ...this.services[0],
      ...this.services[1]
    };
    const datePickerDeps = {
      ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
      uiSettingsKeys: _common.UI_SETTINGS
    };
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: this.services[0].theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_embeddable_loading_fallback.EmbeddableLoading, null)
    }, /*#__PURE__*/_react.default.createElement(IndexDataVisualizerViewWrapper, {
      id: this.input.id,
      embeddableContext: this,
      embeddableInput: this.getInput$(),
      onOutputChange: output => this.updateOutput(output)
    })))))), node);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
  reload() {
    this.reload$.next();
  }
  supportedTriggers() {
    return [];
  }
}
exports.DataVisualizerGridEmbeddable = DataVisualizerGridEmbeddable;