"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataComparisonChartTooltipBody = void 0;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/field-formats-plugin/common");
var _default_value_formatter = require("./charts/default_value_formatter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const style = {
  textAlign: 'right'
};
const DataComparisonChartTooltipBody = ({
  items
}) => {
  const percentFormatter = (0, _default_value_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.PERCENT);
  const footer = items.length > 1 ? /*#__PURE__*/_react.default.createElement(_charts.TooltipTableFooter, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, null), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, "Diff"), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, items[1].datum.doc_count - items[0].datum.doc_count), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, percentFormatter(items[1].datum.percentage - items[0].datum.percentage)))) : null;
  return /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
    gridTemplateColumns: `repeat(${4}, auto)`,
    maxHeight: 120
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableHeader, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, null, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, null), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, null, "Count"), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, null, "Percent"))), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableBody, null, items.map(({
    label,
    datum,
    seriesIdentifier: {
      key
    },
    color
  }) => /*#__PURE__*/_react.default.createElement(_charts.TooltipTableRow, {
    key: `${key}-${datum.x}`
  }, /*#__PURE__*/_react.default.createElement(_charts.TooltipTableColorCell, {
    color: color
  }), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, label), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, datum.doc_count), /*#__PURE__*/_react.default.createElement(_charts.TooltipTableCell, {
    style: style
  }, percentFormatter(datum.percentage))))), footer);
};
exports.DataComparisonChartTooltipBody = DataComparisonChartTooltipBody;