"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointContentWithMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expanded_row_content = require("../../stats_table/components/field_data_expanded_row/expanded_row_content");
var _document_stats = require("../../stats_table/components/field_data_expanded_row/document_stats");
var _examples_list = require("../../examples_list");
var _kibana_context = require("../../../../kibana_context");
var _constants = require("../../../../../../common/constants");
var _embedded_map = require("../../embedded_map");
var _expanded_row_panel = require("../../stats_table/components/field_data_expanded_row/expanded_row_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GeoPointContentWithMap = ({
  config,
  dataView,
  combinedQuery,
  esql,
  timeFieldName
}) => {
  const {
    stats
  } = config;
  const [layerList, setLayerList] = (0, _react.useState)([]);
  const {
    services: {
      maps: mapsPlugin,
      data
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();

  // Update the layer list  with updated geo points upon refresh
  (0, _react.useEffect)(() => {
    async function updateIndexPatternSearchLayer() {
      if ((dataView === null || dataView === void 0 ? void 0 : dataView.id) !== undefined && config !== undefined && config.fieldName !== undefined && (config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_POINT || config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE)) {
        var _data$query$filterMan;
        const params = {
          indexPatternId: dataView.id,
          geoFieldName: config.fieldName,
          geoFieldType: config.type,
          filters: (_data$query$filterMan = data.query.filterManager.getFilters()) !== null && _data$query$filterMan !== void 0 ? _data$query$filterMan : [],
          ...(typeof esql === 'string' ? {
            esql,
            type: 'ESQL'
          } : {}),
          ...(combinedQuery ? {
            query: {
              query: combinedQuery.searchString,
              language: combinedQuery.searchQueryLanguage
            }
          } : {})
        };
        const searchLayerDescriptor = mapsPlugin ? await mapsPlugin.createLayerDescriptors.createESSearchSourceLayerDescriptor(params) : null;
        if (searchLayerDescriptor !== null && searchLayerDescriptor !== void 0 && searchLayerDescriptor.sourceDescriptor) {
          if (esql !== undefined) {
            var _dataView$timeFieldNa;
            // Currently, createESSearchSourceLayerDescriptor doesn't support ES|QL yet
            // but we can manually override the source descriptor with the ES|QL ESQLSourceDescriptor
            const esqlSourceDescriptor = {
              columns: [{
                name: config.fieldName,
                type: config.type
              }],
              dataViewId: dataView.id,
              dateField: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : timeFieldName,
              geoField: config.fieldName,
              esql,
              narrowByGlobalSearch: true,
              narrowByGlobalTime: true,
              narrowByMapBounds: true,
              id: searchLayerDescriptor.sourceDescriptor.id,
              type: 'ESQL',
              applyForceRefresh: true
            };
            setLayerList([...layerList, {
              ...searchLayerDescriptor,
              sourceDescriptor: esqlSourceDescriptor
            }]);
          } else {
            setLayerList([...layerList, searchLayerDescriptor]);
          }
        }
      }
    }
    updateIndexPatternSearchLayer();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataView, combinedQuery, esql, config, mapsPlugin, data.query]);
  if ((stats === null || stats === void 0 ? void 0 : stats.examples) === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerIndexBasedMapContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: stats === null || stats === void 0 ? void 0 : stats.examples
  }), /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvMap__wrapper',
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_embedded_map.EmbeddedMapComponent, {
    layerList: layerList
  })));
};
exports.GeoPointContentWithMap = GeoPointContentWithMap;