"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetDataViewsRoute = exports.getDataViews = void 0;
var _configSchema = require("@kbn/config-schema");
var _handle_errors = require("./util/handle_errors");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDataViews = async ({
  dataViewsService,
  usageCollection,
  counterName
}) => {
  usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.incrementCounter({
    counterName
  });
  return dataViewsService.getIdsWithTitle();
};
exports.getDataViews = getDataViews;
const getDataViewsRouteFactory = (path, serviceKey) => (router, getStartServices, usageCollection) => {
  const responseValidation = () => {
    const dataViewListSchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      title: _configSchema.schema.string(),
      type: _configSchema.schema.maybe(_configSchema.schema.string()),
      typeMeta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
        unknowns: 'allow'
      })),
      name: _configSchema.schema.maybe(_configSchema.schema.string())
    }));
    return _configSchema.schema.object({
      [serviceKey]: dataViewListSchema
    });
  };
  router.versioned.get({
    path,
    access: 'public'
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION,
    validate: {
      request: {},
      response: {
        200: {
          body: responseValidation
        }
      }
    }
  }, router.handleLegacyErrors((0, _handle_errors.handleErrors)(async (ctx, req, res) => {
    const core = await ctx.core;
    const savedObjectsClient = core.savedObjects.client;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const [,, {
      dataViewsServiceFactory
    }] = await getStartServices();
    const dataViewsService = await dataViewsServiceFactory(savedObjectsClient, elasticsearchClient, req);
    const dataViews = await getDataViews({
      dataViewsService,
      usageCollection,
      counterName: `${req.route.method} ${path}`
    });
    const body = {
      [serviceKey]: dataViews
    };
    return res.ok({
      headers: {
        'content-type': 'application/json'
      },
      body
    });
  })));
};
const registerGetDataViewsRoute = exports.registerGetDataViewsRoute = getDataViewsRouteFactory(_constants.SERVICE_PATH, _constants.SERVICE_KEY);