"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStubDataView = void 0;
var _mocks = require("@kbn/field-formats-plugin/public/mocks");
var _mocks2 = require("@kbn/core/public/mocks");
var commonStubs = _interopRequireWildcard(require("../../common/stubs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Create a custom stub index pattern. Use it in your unit tests where an {@link DataView} expected.
 * @param spec - Serialized index pattern object
 * @param opts - Specify index pattern options
 * @param deps - Optionally provide dependencies, you can provide a custom field formats implementation, by default client side registry with real formatters implementation is used
 *
 * @returns - an {@link DataView} instance
 *
 * @remark - This is a client side version, a browser-agnostic version is available in {@link commonStubs | common}.
 * The main difference is that client side version by default uses client side field formats service, where common version uses a dummy field formats mock.
 *
 * @example
 *
 * You can provide a custom implementation or assert calls using jest.spyOn:
 *
 * ```ts
 *  const indexPattern = createStubIndexPattern({spec: {title: 'logs-*'}});
 *  const spy = jest.spyOn(indexPattern, 'getFormatterForField');
 *
 *  // use `spy` as a regular jest mock
 *
 * ```
 */
const createStubDataView = ({
  spec,
  opts,
  deps
}) => {
  var _deps$fieldFormats, _deps$core;
  return commonStubs.createStubDataView({
    spec,
    opts,
    deps: {
      fieldFormats: (_deps$fieldFormats = deps === null || deps === void 0 ? void 0 : deps.fieldFormats) !== null && _deps$fieldFormats !== void 0 ? _deps$fieldFormats : (0, _mocks.getFieldFormatsRegistry)((_deps$core = deps === null || deps === void 0 ? void 0 : deps.core) !== null && _deps$core !== void 0 ? _deps$core : _mocks2.coreMock.createSetup())
    }
  });
};
exports.createStubDataView = createStubDataView;