"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RUNTIME_FIELD_TYPES = exports.PLUGIN_NAME = exports.META_FIELDS = exports.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = exports.FIELDS_PATH = exports.FIELDS_FOR_WILDCARD_PATH = exports.EXISTING_INDICES_PATH = exports.DEFAULT_DATA_VIEW_ID = exports.DEFAULT_ASSETS_TO_IGNORE = exports.DATA_VIEW_SAVED_OBJECT_TYPE = exports.DATA_VIEWS_FIELDS_EXCLUDED_TIERS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * All runtime field types.
 * @public
 */
const RUNTIME_FIELD_TYPES = exports.RUNTIME_FIELD_TYPES = ['keyword', 'long', 'double', 'date', 'ip', 'boolean', 'geo_point', 'composite'];

/**
 * Used to optimize on-boarding experience to determine if the instance has some user created data views or data indices/streams by filtering data sources
 * that are created by default by elastic in ese.
 * We should somehow prevent creating initial data for the users without their explicit action
 * instead of relying on these hardcoded assets
 */
const DEFAULT_ASSETS_TO_IGNORE = exports.DEFAULT_ASSETS_TO_IGNORE = {
  DATA_STREAMS_TO_IGNORE: ['logs-enterprise_search.api-default',
  // https://github.com/elastic/kibana/issues/134918
  `logs-enterprise_search.audit-default` // https://github.com/elastic/kibana/issues/134918
  ]
};

/**
 * UiSettings key for metaFields list.
 * @public
 */
const META_FIELDS = exports.META_FIELDS = 'metaFields';

/**
 * Data view saved object type.
 * @public
 */
const DATA_VIEW_SAVED_OBJECT_TYPE = exports.DATA_VIEW_SAVED_OBJECT_TYPE = 'index-pattern';

/**
 * Data views plugin name.
 * @public
 */
const PLUGIN_NAME = exports.PLUGIN_NAME = 'DataViews';

/**
 * Max length for the custom field description
 */
const MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = exports.MAX_DATA_VIEW_FIELD_DESCRIPTION_LENGTH = 300;

/**
 * Fields for wildcard path.
 * @public
 */
const FIELDS_FOR_WILDCARD_PATH = exports.FIELDS_FOR_WILDCARD_PATH = '/internal/data_views/_fields_for_wildcard';

/**
 * Fields path. Like fields for wildcard but GET only
 * @public
 */
const FIELDS_PATH = exports.FIELDS_PATH = '/internal/data_views/fields';

/**
 * Existing indices path
 * @public
 */
const EXISTING_INDICES_PATH = exports.EXISTING_INDICES_PATH = '/internal/data_views/_existing_indices';
const DATA_VIEWS_FIELDS_EXCLUDED_TIERS = exports.DATA_VIEWS_FIELDS_EXCLUDED_TIERS = 'data_views:fields_excluded_data_tiers';
const DEFAULT_DATA_VIEW_ID = exports.DEFAULT_DATA_VIEW_ID = 'defaultIndex';