"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _field_preview_context = require("./field_preview_context");
var _field_preview_header = require("./field_preview_header");
var _field_preview_empty_prompt = require("./field_preview_empty_prompt");
var _documents_nav_preview = require("./documents_nav_preview");
var _field_preview_error = require("./field_preview_error");
var _field_list_item = require("./field_list/field_list_item");
var _field_list = require("./field_list/field_list");
var _state_utils = require("../../state_utils");
require("./field_preview.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const previewResponseSelector = state => state.previewResponse;
const fetchDocErrorSelector = state => state.fetchDocError;
const isLoadingPreviewSelector = state => state.isLoadingPreview;
const isPreviewAvailableSelector = state => state.isPreviewAvailable;
const FieldPreview = () => {
  const [fieldListHeight, setFieldListHeight] = (0, _react.useState)(-1);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    params: {
      value: {
        name,
        script,
        format
      }
    },
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const {
    fields,
    error
  } = (0, _state_utils.useStateSelector)(controller.state$, previewResponseSelector);
  const fetchDocError = (0, _state_utils.useStateSelector)(controller.state$, fetchDocErrorSelector);
  const isLoadingPreview = (0, _state_utils.useStateSelector)(controller.state$, isLoadingPreviewSelector);
  const isPreviewAvailable = (0, _state_utils.useStateSelector)(controller.state$, isPreviewAvailableSelector);

  // To show the preview we at least need a name to be defined, the script or the format
  // and an first response from the _execute API
  let isEmptyPromptVisible = false;
  const noParamDefined = name === null && script === null && format === null;
  const haveResultFromPreview = error !== null || fields.length > 0;
  if (noParamDefined) {
    isEmptyPromptVisible = true;
  } else if (!haveResultFromPreview && !isLoadingPreview && name === null && format === null) {
    isEmptyPromptVisible = true;
  }
  const doRenderListOfFields = fetchDocError === null;
  const showWarningPreviewNotAvailable = isPreviewAvailable === false && fetchDocError === null;
  const onFieldListResize = (0, _react.useCallback)(({
    height
  }) => {
    setFieldListHeight(height);
  }, []);
  const renderFieldsToPreview = () => {
    if (fields.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("ul", null, fields.map((field, i) => /*#__PURE__*/_react.default.createElement("li", {
      key: i,
      "data-test-subj": "fieldPreviewItem"
    }, /*#__PURE__*/_react.default.createElement(_field_list_item.PreviewListItem, {
      field: field,
      isFromScript: true,
      hasScriptError: Boolean(error)
    }))));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "indexPatternFieldEditor__previewPannel"
    // This tabIndex is for the scrollable area of the flyout panel.
    ,
    tabIndex: 0
  }, isEmptyPromptVisible ? /*#__PURE__*/_react.default.createElement(_field_preview_empty_prompt.FieldPreviewEmptyPrompt, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_preview_header.FieldPreviewHeader, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), showWarningPreviewNotAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.notAvailableWarningCallout.title', {
      defaultMessage: 'Preview not available'
    }),
    color: "warning",
    iconType: "warning",
    role: "alert",
    "data-test-subj": "previewNotAvailableCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.notAvailableWarningCallout.description', {
    defaultMessage: 'Runtime field preview is disabled because no documents could be fetched from the cluster.'
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_documents_nav_preview.DocumentsNavPreview, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), doRenderListOfFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchValue,
    onChange: e => setSearchValue(e.target.value),
    placeholder: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.filterFieldsPlaceholder', {
      defaultMessage: 'Filter fields'
    }),
    fullWidth: true,
    "data-test-subj": "filterFieldsInput"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_field_preview_error.FieldPreviewError, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), doRenderListOfFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderFieldsToPreview(), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onFieldListResize
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: resizeRef,
    style: {
      flex: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_field_list.PreviewFieldList, {
    height: fieldListHeight,
    clearSearch: () => setSearchValue(''),
    searchValue: searchValue
    // We add a key to force rerender the virtual list whenever the window height changes
    ,
    key: fieldListHeight
  })))))));
};
exports.FieldPreview = FieldPreview;